% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{DPxy}
\alias{DPxy}
\title{A function to compute the distance-decay interaction index (DPxy)}
\usage{
DPxy(x, d = NULL, distin = 'm',  distout = 'm', diagval = '0', 
beta = 1, spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{d}{- a matrix of the distances between spatial unit centroids}

\item{distin}{- input metric conversion, based on  \pkg{bink} package and 
includes conversions from 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{distout}{- output metric conversion, based on  \pkg{bink} package and 
includes conversions to 'm', 'km', 'inch', 'ft', 'yd', 'mi', 'naut_mi', etc.}

\item{diagval}{- when providing a spatial object or a shape file, 
the user has the choice of the spatial matrix diagonal definition: 
diagval = '0' (by default) for an null diagonal and diagval = 'a' 
to compute the diagonal as 0.6 * square root (spatial/organizational unitsarea) (White, 1983)}

\item{beta}{- distance decay parameter}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame) with 
geographic information}

\item{folder}{- a character vector with the folder (directory) 
name indicating where the shapefile is located on the drive}

\item{shape}{- a character vector with the name of the shapefile 
(without the .shp extension).}
}
\value{
a numeric matrix containing the distance-decay isolation index 
values
}
\description{
The distance decay interaction index, DPxy, is a 
spatial adaptation of interaction index \code{\link{xPy}}. 
The function can be used in two ways: to provide a distance matrix 
or a external geographic information source (spatial object or shape file).
}
\examples{
x <- segdata@data[ ,1:2]
ar <- area(segdata)
dist <- distance(segdata)
diag(dist)<-sqrt(ar) * 0.6
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'segdata'

DPxy(x, d = dist)

DPxy(x, spatobj = segdata, diagval = 'a')

DPxy(x, folder = foldername, shape = shapename, diagval = '0') 
}
\references{
Morgan, B. S. (1983) \emph{An Alternate Approach to the 
Development of a Distance-Based Measure of Racial Segregation}. 
American Journal of Sociology 88,  pp. 1237-1249.
}
\seealso{
Isolation indices: 
\code{\link{xPx}}, \code{\link{Eta2}},  \code{\link{DPxx}}

Interaction index: \code{\link{xPy}}
}
