% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{xPx}
\alias{xPx}
\title{A function to compute Bell's isolation index (xPx)}
\usage{
xPx(x, exact = FALSE)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a group within 
spatial units. The number of columns should be greater than 1 (at least 2 
groups are required). You should not include a column with total 
population, because this will be interpreted as a group.}

\item{exact}{- a logical variable to specifiy the index version: 
exact = FALSE (by default) for the approximate version of the index, 
and exact = TRUE for the exact version}
}
\value{
a numeric vector containing the isolation index value for 
each group
}
\description{
The isolation index, xPx, is an exposure index 
that measures the probability that two members of a group share 
the same spatial unit. This index can be calculated using the 
approximate or the exact method (see Bell, 1954).
}
\examples{
x <- segdata@data[ ,7:8]
xPx(x) 
xPx(x, exact = TRUE)
}
\references{
Bell W. (1954) \emph{A probability model for the 
measurement of ecological segregation}. Social Forces 32(4), 
pp. 357-364
}
\seealso{
Isolation indices: 
\code{\link{Eta2}},  \code{\link{DPxx}}

Interaction indices: 
\code{\link{xPy}}, \code{\link{DPxy}}
}
