% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_n.R
\name{olink_normalization_bridge}
\alias{olink_normalization_bridge}
\title{Bridge normalization of all proteins between two NPX projects.}
\usage{
olink_normalization_bridge(
  project_1_df,
  project_2_df,
  bridge_samples,
  project_1_name = "P1",
  project_2_name = "P2",
  project_ref_name = "P1"
)
}
\arguments{
\item{project_1_df}{Data frame of the first project (required).}

\item{project_2_df}{Data frame of the second project (required).}

\item{bridge_samples}{Named list of 2 arrays containing SampleID of shared
samples to be used for the calculation of adjustment factor. The
names of the two arrays should be DF1 and DF2 corresponding to projects 1
and 2, respectively. Arrays should be of equal length and index of each entry
should correspond to the same sample. (required)}

\item{project_1_name}{Name of the first project (default: P1).}

\item{project_2_name}{Name of the second project (default: P2).}

\item{project_ref_name}{Name of the project to be used as reference set.
Needs to be one of the project_1_name or project_2_name. It marks the
project to which the other project will be adjusted to (default: P1).}
}
\value{
A "tibble" of NPX data in long format containing normalized NPX
values, including adjustment factors and name of project.
}
\description{
Normalizes two NPX projects (data frames) using shared samples.\cr\cr
}
\details{
This function is a wrapper of olink_normalization.\cr\cr

In bridging normalization one of the projects is adjusted to another using
shared samples (bridge samples). It is not necessary for the shared
samples to be named the same in each project. Adjustment between the two
projects is made using the median of the paired differences between the
shared samples. The two data frames are inputs project_1_df and project_2_df,
the one being adjusted to is specified in the input project_ref_name and the
shared samples are specified in bridge_samples.\cr\cr
}
\examples{
\donttest{
npx_df1 <- npx_data1 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::select(-Project) |>
  dplyr::mutate(Normalization = "Intensity")
npx_df2 <- npx_data2 |>
  dplyr::filter(!stringr::str_detect(SampleID, "CONTROL_")) |>
  dplyr::select(-Project) |>
  dplyr::mutate(Normalization = "Intensity")

# Find overlapping samples, but exclude Olink control
overlap_samples <- dplyr::intersect(unique(npx_df1$SampleID),
                                    unique(npx_df2$SampleID))
overlap_samples_list <- list("DF1" = overlap_samples,
                             "DF2" = overlap_samples)

# Normalize
olink_normalization_bridge(project_1_df = npx_df1,
                           project_2_df = npx_df2,
                           bridge_samples = overlap_samples_list,
                           project_1_name = "P1",
                           project_2_name = "P2",
                           project_ref_name = "P1")
}

}
\keyword{Bridge}
\keyword{Normalization}
