% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proteomics-class.R
\name{proteomics}
\alias{proteomics}
\title{Sub-class proteomics}
\description{
This is a sub-class that is compatible to preprocessed data obtained from https://fragpipe.nesvilab.org/.
It inherits all methods from the abstract class \link{omics} and only adapts the \code{initialize} function.
It supports pre-existing data structures or paths to text files.
When omics data is very large, data loading becomes very expensive. It is therefore recommended to use the \href{#method-reset}{\code{reset()}} method to reset your changes.
Every omics class creates an internal memory efficient back-up of the data, the resetting of changes is an instant process.
}
\examples{

## ------------------------------------------------
## Method `proteomics$print`
## ------------------------------------------------

prot_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
prot <- readRDS(prot_path)

# method 1 to call print function
prot

# method 2 to call print function
prot$print()


## ------------------------------------------------
## Method `proteomics$reset`
## ------------------------------------------------

 
prot_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
prot <- readRDS(prot_path)

# Performs modifications
prot$transform(log2)

# resets
prot$reset()


## ------------------------------------------------
## Method `proteomics$removeZeros`
## ------------------------------------------------

prot_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
prot <- readRDS(prot_path)

# Sample subset induces empty features
prot$sample_subset(treatment == "tumor")

# Remove empty features from countData and treeData
prot$removeZeros()

}
\seealso{
\link{omics}
}
\section{Super class}{
\code{\link[OmicFlow:omics]{OmicFlow::omics}} -> \code{proteomics}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{countData}}{A path to an existing file, data.table or data.frame.}

\item{\code{metaData}}{A path to an existing file, data.table or data.frame.}

\item{\code{featureData}}{A path to an existing file, data.table or data.frame.}

\item{\code{treeData}}{A path to an existing newick file or class "phylo", see \link[ape]{read.tree}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-proteomics-new}{\code{proteomics$new()}}
\item \href{#method-proteomics-print}{\code{proteomics$print()}}
\item \href{#method-proteomics-reset}{\code{proteomics$reset()}}
\item \href{#method-proteomics-removeZeros}{\code{proteomics$removeZeros()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="DFE"><a href='../../OmicFlow/html/omics.html#method-omics-DFE'><code>OmicFlow::omics$DFE()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="alpha_diversity"><a href='../../OmicFlow/html/omics.html#method-omics-alpha_diversity'><code>OmicFlow::omics$alpha_diversity()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="autoFlow"><a href='../../OmicFlow/html/omics.html#method-omics-autoFlow'><code>OmicFlow::omics$autoFlow()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="composition"><a href='../../OmicFlow/html/omics.html#method-omics-composition'><code>OmicFlow::omics$composition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="feature_merge"><a href='../../OmicFlow/html/omics.html#method-omics-feature_merge'><code>OmicFlow::omics$feature_merge()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="feature_subset"><a href='../../OmicFlow/html/omics.html#method-omics-feature_subset'><code>OmicFlow::omics$feature_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="normalize"><a href='../../OmicFlow/html/omics.html#method-omics-normalize'><code>OmicFlow::omics$normalize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="ordination"><a href='../../OmicFlow/html/omics.html#method-omics-ordination'><code>OmicFlow::omics$ordination()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="rankstat"><a href='../../OmicFlow/html/omics.html#method-omics-rankstat'><code>OmicFlow::omics$rankstat()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="removeNAs"><a href='../../OmicFlow/html/omics.html#method-omics-removeNAs'><code>OmicFlow::omics$removeNAs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="sample_subset"><a href='../../OmicFlow/html/omics.html#method-omics-sample_subset'><code>OmicFlow::omics$sample_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="samplepair_subset"><a href='../../OmicFlow/html/omics.html#method-omics-samplepair_subset'><code>OmicFlow::omics$samplepair_subset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="transform"><a href='../../OmicFlow/html/omics.html#method-omics-transform'><code>OmicFlow::omics$transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="OmicFlow" data-topic="omics" data-id="validate"><a href='../../OmicFlow/html/omics.html#method-omics-validate'><code>OmicFlow::omics$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-proteomics-new"></a>}}
\if{latex}{\out{\hypertarget{method-proteomics-new}{}}}
\subsection{Method \code{new()}}{
Initializes the proteomics class object with \code{proteomics$new()}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{proteomics$new(countData = NA, metaData = NA, featureData = NA, treeData = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{countData}}{countData A path to an existing file or sparseMatrix.}

\item{\code{metaData}}{A path to an existing file, data.table or data.frame.}

\item{\code{featureData}}{A path to an existing file, data.table or data.frame.}

\item{\code{treeData}}{A path to an existing newick file or class "phylo", see \link[ape]{read.tree}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{proteomics} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-proteomics-print"></a>}}
\if{latex}{\out{\hypertarget{method-proteomics-print}{}}}
\subsection{Method \code{print()}}{
Displays parameters of the proteomics object via stdout.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{proteomics$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{prot_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
prot <- readRDS(prot_path)

# method 1 to call print function
prot

# method 2 to call print function
prot$print()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-proteomics-reset"></a>}}
\if{latex}{\out{\hypertarget{method-proteomics-reset}{}}}
\subsection{Method \code{reset()}}{
Upon creation of a new \code{proteomics} object a small backup of the original data is created.
Since modification of the object is done by reference and duplicates are not made, it is possible to \code{reset} changes to the class.
The methods from the abstract class \link{omics} also contains a private method to prevent any changes to the original object when using methods such as \code{ordination} \code{alpha_diversity} or \code{$DFE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{proteomics$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ 
prot_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
prot <- readRDS(prot_path)

# Performs modifications
prot$transform(log2)

# resets
prot$reset()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-proteomics-removeZeros"></a>}}
\if{latex}{\out{\hypertarget{method-proteomics-removeZeros}{}}}
\subsection{Method \code{removeZeros()}}{
Removes empty (zero) values by row, column and tips from the \code{countData} and \code{treeData}.
This method is performed automatically during subsetting of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{proteomics$removeZeros()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{prot_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
prot <- readRDS(prot_path)

# Sample subset induces empty features
prot$sample_subset(treatment == "tumor")

# Remove empty features from countData and treeData
prot$removeZeros()

}
\if{html}{\out{</div>}}

}

}
}
