% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardBootIntervals.R
\name{standardBootIntervals}
\alias{standardBootIntervals}
\title{standardBootIntervals}
\usage{
standardBootIntervals(boot, lower = 0.025, upper = 0.975)
}
\arguments{
\item{boot}{A vector of bootstrap results}

\item{lower}{the lower alpha}

\item{upper}{the upper alpha}
}
\value{
A matrix of the mean, median, min, max, lower and upper CI values
}
\description{
This returns the quantiles of the bootstrap samples specified by the user. The quantiles uses the type=6 argument of the quantile function, which appears to function best.
}
\examples{
data<-DFSimulated()
boots<-NaiveBoot(data, groups="Rs", keepgroups=TRUE)
boots<-bootAnalysis(boots, cbind, DFanalysis,1,2,3,TRUE,FALSE,TRUE,TRUE,FALSE)
apply(boots,1, standardBootIntervals)
DFanalysis(data,1,2,3)
}
