% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findSa.R
\name{findSa}
\alias{findSa}
\title{findSa}
\usage{
findSa(S, fitted, p, a = 0.5, df, n, tau = NULL, tol = 1e-07)
}
\arguments{
\item{S}{Sample covariance matrix}

\item{fitted}{The fitted covariance matrix}

\item{p}{the number of columns in the covariance matrix}

\item{a}{the starting value for the a parameter}

\item{df}{the degrees of freedom in the model}

\item{n}{the number of participants in the model}

\item{tau}{the population tau. If no tau is provided, the estimated tau from the model will be used}

\item{tol}{the difference between ga and tau at which the function will converge}
}
\value{
a list of the "a" adjusted covariance matrix, Sa, the tau, ga, and the number of interations.
}
\description{
This is an implementation of the YHY bootstrap covariance matrix.
}
\examples{
require(Omisc)
require(lavaan)
set.seed(2^7-1)
modelTest<-'
LV1=~ .7*x1+.8*x2+.75*x3+.6*x4
LV2=~ .7*y1+.8*y2+.75*y3+.6*y4
LV1~~.3*LV2
LV1~~1*LV1
LV2~~1*LV2
'
modelFit<-'
LV1=~ x1+x2+x3+x4
LV2=~ y1+y2+y3+y4
LV1~~start(.5)*LV2
LV1~~1*LV1
LV2~~1*LV2
'

testdata<-simulateData(modelTest, sample.nobs = 250)
fit<-cfa(modelFit, testdata)

fitted<-fitted(fit)$cov
fitted<-fitted[,1:ncol(fitted)]
S<-cov(testdata)
p<-8
a<-.5
n<-250
df<-21
findSa(S, fitted, p, .5, df, n)
}
