% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableInObservation.R
\name{tableInObservation}
\alias{tableInObservation}
\title{Create a visual table from a summariseInObservation() result.}
\usage{
tableInObservation(result, type = "gt")
}
\arguments{
\item{result}{A summarised_result object.}

\item{type}{Type of formatting output table, either "gt", "reactable" or "datatable".}
}
\value{
A gt or flextable object with the summarised data.
}
\description{
Create a visual table from a summariseInObservation() result.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch()

result <- summariseInObservation(
  cdm$observation_period,
  interval = "months",
  output = c("person-days", "record"),
  ageGroup = list("<=60" = c(0, 60), ">60" = c(61, Inf)),
  sex = TRUE
)

result |>
  tableInObservation()

PatientProfiles::mockDisconnect(cdm)
}
}
