% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_KJ.R
\name{Sim_KJ}
\alias{Sim_KJ}
\title{Calculate Empirical Power by Simulation for the Optimal Two-Stage Design Using
One-Sample Log-Rank Test with Unrestricted Follow-Up}
\usage{
Sim_KJ(dist, shape, S0, S1, x0, tf, rate, t1, c1, c, n1, n, N, seed = 123)
}
\arguments{
\item{dist}{distribution options with 'WB' as Weibull, 'GM' as Gamma,
'LN' as log-normal, 'LG' as log-logistic for the baseline hazard function.}

\item{shape}{shape parameter of the baseline hazard function assuming one of the four possible parametric distributions ('WB', 'GM',
'LN' and 'LG').}

\item{S0}{survival probability at a fixed time point x0 under the null hypothesis.}

\item{S1}{survival probability at a fixed time point x0 under the alternative hypothesis.}

\item{x0}{a fixed time point where the survival probabilities are known for both
null and alternative hypotheses.}

\item{tf}{unrestricted follow-up time, the time period from the entry of the last patient to the end of the trial.}

\item{rate}{a constant accrual rate.}

\item{t1}{the interim analysis time as given by the two-stage design.}

\item{c1}{the critical value given by the two-stage design for the interim analysis.}

\item{c}{the critical value given by the two-stage design for the final analysis.}

\item{n1}{the required sample size given by the two-stage design for the interim analysis.}

\item{n}{the required sample size given by the two-stage design for the final stage.}

\item{N}{number of trials in the simulation.}

\item{seed}{seed for random number generation.}
}
\value{
a numeric value that is either the empirical power (when S1=S0^hr) or the type I-error (when S1=S0).
}
\description{
Sim_KJ() can be used to calculate empirical power and type-I error by simulation
given the design parameters (e.g., n1, n, c1, c) obtained from the optimal two-stage design with
unrestricted follow-up.
}
\examples{
\donttest{Design2 <- Optimal.KJ(dist="WB", shape=1, S0=0.62, x0=2, hr=0.467, tf=2, rate=5,
alpha=0.05, beta=0.2)}
# ##' # $Two_stage
#   n1     c1  n      c     t1 MTSL      ES     PS
# 1 16 -0.302 26 1.6135 3.0593  7.2 21.9187 0.3813

# calculate empirical power and type I error given the above design parameters
Sim_KJ(dist="WB", shape=1, S0=0.62, S1=0.62^(0.467), x0=2, tf=2, rate=5, t1=3.0593,
    c1=-0.302, c=1.6135, n1=16, n=26, N=10000, seed=5868)
# empirical power
# 0.813

Sim_KJ(dist="WB", shape=1, S0=0.62, S1=0.62, x0=2, tf=2, rate=5, t1=3.0593,
    c1=-0.302, c=1.6135, n1=16, n=26, N=10000, seed=5868)
# empirical type-I error
# 0.037
}
