% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneR.R
\name{eval_model}
\alias{eval_model}
\title{Classification Evaluation function}
\usage{
eval_model(prediction, actual, dimnames = c("Prediction", "Actual"),
  zero.print = "0")
}
\arguments{
\item{prediction}{vector which contains the predicted values.}

\item{actual}{dataframe which contains the actual data. When there is more than one column the last last column is taken. A single vector is allowed too.}

\item{dimnames}{character vector of printed dimnames for the confusion matrices.}

\item{zero.print}{character specifying how zeros should be printed; for sparse confusion matrices, using "." can produce more readable results.}
}
\value{
Invisibly returns a list with the number of correctly classified and total instances and a confusion matrix with the absolute numbers.
}
\description{
Function for evaluating a OneR classification model. Prints confusion matrices with prediction vs. actual in absolute and relative numbers. Additionally it gives the accuracy, error rate as well as the error rate reduction versus the base rate accuracy together with a p-value.
}
\details{
Error rate reduction versus the base rate accuracy is calculated by the following formula:\cr\cr
\eqn{(Accuracy(Prediction) - Accuracy(Baserate)) / (1 - Accuracy(Baserate))},\cr\cr
giving a number between 0 (no error reduction) and 1 (no error).\cr\cr
In some borderline cases when the model is performing worse than the base rate negative numbers can result. This shows that something is seriously wrong with the model generating this prediction.\cr\cr
The provided p-value gives the probability of obtaining a distribution of predictions like this (or even more unambiguous) under the assumption that the real accuracy is equal to or lower than the base rate accuracy.
More technicaly it is derived from a one-sided binomial test with the alternative hypothesis that the prediction's accuracy is bigger than the base rate accuracy.
Loosly speaking a low p-value (< 0.05) signifies that the model really is able to give predictions that are better than the base rate.
}
\examples{
data <- iris
model <- OneR(data)
summary(model)
prediction <- predict(model, data)
eval_model(prediction, data)
}
\author{
Holger von Jouanne-Diedrich
}
\references{
\url{https://github.com/vonjd/OneR}
}
\keyword{accuracy}
\keyword{evaluation}

