% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{Model}
\alias{Model}
\title{R6Class Model}
\description{
Wrapper class for the \code{model} C struct (\emph{model.h}).
}
\details{
Model used for running the simulation. Initialise the model by creating
a \code{\link{Parameters}} instance.

For a detailed explanation of the model, please read the
\href{https://github.com/BDI-pathogens/OpenABM-Covid19/blob/master/documentation/covid19.md}{Online Documentation}
}
\examples{
# Create a model using the baseline parameters included in the package.
# Note: This initialisation can take a few seconds.
model <- Model.new( params = list( n_total = 10000, manual_trace_on = 1) )

# Get a parameter
Model.get_param(model, 'manual_trace_on')

# Change (update) a parameter
Model.update_running_params(model, 'manual_trace_on', 0)

if (!is.null(model)) {
  # Set / get risk scores. Score are values between 0 and 1.
  day <- 1
  infectors   <- AgeGroupEnum[['_10_19']]
  susceptible <- AgeGroupEnum[['_60_69']]
  model$get_risk_score( day, infectors, susceptible )
  model$set_risk_score( day, infectors, susceptible, 0.5 )
  model$get_risk_score_household( infectors, susceptible )
  model$set_risk_score_household( infectors, susceptible, 0.5 )

  # Getting a network
  nw <- model$get_network_by_id(3)

  # Set / get app users
  users <- model$get_app_users()
  users[['app_user']] <- as.integer(!users[['app_user']]) # reverse values
  model$set_app_users(users)
}

}
\seealso{
\code{\link{Parameters}}

\code{\link{AgeGroupEnum}}

\code{\link{SAFE_UPDATE_PARAMS}}

\code{\link{NETWORK_CONSTRUCTIONS}}
the C model R pointer object
check the C model still exists
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{c_model}}{The C model R pointer object (SWIG wrapped)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Model$new()}}
\item \href{#method-finalize}{\code{Model$finalize()}}
\item \href{#method-get_param}{\code{Model$get_param()}}
\item \href{#method-update_running_params}{\code{Model$update_running_params()}}
\item \href{#method-get_risk_score}{\code{Model$get_risk_score()}}
\item \href{#method-get_risk_score_household}{\code{Model$get_risk_score_household()}}
\item \href{#method-set_risk_score}{\code{Model$set_risk_score()}}
\item \href{#method-set_risk_score_household}{\code{Model$set_risk_score_household()}}
\item \href{#method-add_user_network}{\code{Model$add_user_network()}}
\item \href{#method-add_user_network_random}{\code{Model$add_user_network_random()}}
\item \href{#method-get_network_by_id}{\code{Model$get_network_by_id()}}
\item \href{#method-seed_infect_by_idx}{\code{Model$seed_infect_by_idx()}}
\item \href{#method-add_new_strain}{\code{Model$add_new_strain()}}
\item \href{#method-set_cross_immunity_matrix}{\code{Model$set_cross_immunity_matrix()}}
\item \href{#method-get_network_ids}{\code{Model$get_network_ids()}}
\item \href{#method-get_network_info}{\code{Model$get_network_info()}}
\item \href{#method-add_vaccine}{\code{Model$add_vaccine()}}
\item \href{#method-vaccinate_individual}{\code{Model$vaccinate_individual()}}
\item \href{#method-vaccinate_schedule}{\code{Model$vaccinate_schedule()}}
\item \href{#method-get_individuals}{\code{Model$get_individuals()}}
\item \href{#method-get_transmissions}{\code{Model$get_transmissions()}}
\item \href{#method-delete_network}{\code{Model$delete_network()}}
\item \href{#method-get_app_users}{\code{Model$get_app_users()}}
\item \href{#method-set_app_users}{\code{Model$set_app_users()}}
\item \href{#method-one_time_step}{\code{Model$one_time_step()}}
\item \href{#method-results}{\code{Model$results()}}
\item \href{#method-run}{\code{Model$run()}}
\item \href{#method-one_time_step_results}{\code{Model$one_time_step_results()}}
\item \href{#method-write_output_files}{\code{Model$write_output_files()}}
\item \href{#method-write_individual_file}{\code{Model$write_individual_file()}}
\item \href{#method-write_interactions_file}{\code{Model$write_interactions_file()}}
\item \href{#method-write_trace_tokens_timeseries}{\code{Model$write_trace_tokens_timeseries()}}
\item \href{#method-write_trace_tokens}{\code{Model$write_trace_tokens()}}
\item \href{#method-write_transmissions}{\code{Model$write_transmissions()}}
\item \href{#method-write_quarantine_reasons}{\code{Model$write_quarantine_reasons()}}
\item \href{#method-write_occupation_network}{\code{Model$write_occupation_network()}}
\item \href{#method-write_household_network}{\code{Model$write_household_network()}}
\item \href{#method-write_random_network}{\code{Model$write_random_network()}}
\item \href{#method-print_individual}{\code{Model$print_individual()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$new(params_object = NULL, params = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params_object}}{An object of type \code{\link{Parameters}} or NULL
(for default params). The constructor will lock the parameter values (ie.
\code{params_code} will become read-only).}

\item{\code{params}}{A named list of parameters fo override (default NULL for no
overrides).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Remove the C model to prevent leakage
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_param"></a>}}
\if{latex}{\out{\hypertarget{method-get_param}{}}}
\subsection{Method \code{get_param()}}{
Get a parameter value by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_param(param)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{name of param}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
value of stored param
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_running_params"></a>}}
\if{latex}{\out{\hypertarget{method-update_running_params}{}}}
\subsection{Method \code{update_running_params()}}{
A subset of parameters may be updated whilst the model is evaluating,
these correspond to events. This function throws an error if
\code{param} isn't safe to update.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$update_running_params(param, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param}}{name of parameter. See \code{\link{SAFE_UPDATE_PARAMS}} for
allowed parameter names}

\item{\code{value}}{value of parameter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_risk_score"></a>}}
\if{latex}{\out{\hypertarget{method-get_risk_score}{}}}
\subsection{Method \code{get_risk_score()}}{
Gets the value of the risk score parameter.
Wrapper for C API \code{get_model_param_risk_score}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_risk_score(day, age_inf, age_sus)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{day}}{Infection day}

\item{\code{age_inf}}{Infector age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}

\item{\code{age_sus}}{Susceptible age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The risk value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_risk_score_household"></a>}}
\if{latex}{\out{\hypertarget{method-get_risk_score_household}{}}}
\subsection{Method \code{get_risk_score_household()}}{
Gets the value of the risk score household parameter.
Wrapper for C API \code{get_model_param_risk_score_household}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_risk_score_household(age_inf, age_sus)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{age_inf}}{Infector age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}

\item{\code{age_sus}}{Susceptible age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The risk value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_risk_score"></a>}}
\if{latex}{\out{\hypertarget{method-set_risk_score}{}}}
\subsection{Method \code{set_risk_score()}}{
Gets the value of the risk score parameter.
Wrapper for C API \code{set_model_param_risk_score}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$set_risk_score(day, age_inf, age_sus, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{day}}{Infection day}

\item{\code{age_inf}}{Infector age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}

\item{\code{age_sus}}{Susceptible age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}

\item{\code{value}}{The risk value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_risk_score_household"></a>}}
\if{latex}{\out{\hypertarget{method-set_risk_score_household}{}}}
\subsection{Method \code{set_risk_score_household()}}{
Gets the value of the risk score household parameter.
Wrapper for C API \code{set_model_param_risk_score_household}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$set_risk_score_household(age_inf, age_sus, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{age_inf}}{Infector age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}

\item{\code{age_sus}}{Susceptible age group index, value between 0 and 8.
See \code{\link{AgeGroupEnum}} list}

\item{\code{value}}{The risk value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_user_network"></a>}}
\if{latex}{\out{\hypertarget{method-add_user_network}{}}}
\subsection{Method \code{add_user_network()}}{
Adds as bespoke user network from a dataframe of edges
the network is static with the exception of skipping
hospitalised and quarantined people.
Wrapper for C API \code{add_user_network}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$add_user_network(
  df_network,
  interaction_type = 1,
  skip_hospitalised = TRUE,
  skip_quarantine = TRUE,
  construction = NETWORK_CONSTRUCTIONS[["BESPOKE"]],
  daily_fraction = 1,
  name = "user_network"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df_network}}{Network data frame. List of edges, with 2 columns
\code{ID_1} and \code{ID_2}}

\item{\code{interaction_type}}{Must 0 (household), 1 (occupation), or 2 (random)}

\item{\code{skip_hospitalised}}{If \code{TRUE}, skip interaction if either
person is in hospital.}

\item{\code{skip_quarantine}}{If \code{TRUE}, skip interaction if either person
is in quarantined}

\item{\code{construction}}{The method used for network construction. Must be a
number between 0 and 4 (inclusive).
See \code{\link{NETWORK_CONSTRUCTIONS}}.}

\item{\code{daily_fraction}}{The fraction of edges on the network present each
day (i.e. down-sampling the network). Must be a value between 0 and 1.}

\item{\code{name}}{Name of the network.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_user_network_random"></a>}}
\if{latex}{\out{\hypertarget{method-add_user_network_random}{}}}
\subsection{Method \code{add_user_network_random()}}{
Adds a bespoke user random network from a dataframe of people and number
of interactions. The network is regenerates each day, but the number of
interactions per person is static. Hospitalsed and quarantined people
can be skipped
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$add_user_network_random(
  df_interactions,
  skip_hospitalised = TRUE,
  skip_quarantine = TRUE,
  name = "user_network"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df_interactions}}{List of indviduals and interactions. Must be a
dataframe with 2 columns \code{ID} and \code{N}.}

\item{\code{skip_hospitalised}}{Skip interaction if either person is in
hospital. Must a logical value.}

\item{\code{skip_quarantine}}{Skip interaction if either person is in
quarantined. Must a logical value.}

\item{\code{name}}{The name of the network.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_network_by_id"></a>}}
\if{latex}{\out{\hypertarget{method-get_network_by_id}{}}}
\subsection{Method \code{get_network_by_id()}}{
Get a network.
Wrapper for C API \code{get_network_by_id}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_network_by_id(network_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_id}}{The network ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-seed_infect_by_idx"></a>}}
\if{latex}{\out{\hypertarget{method-seed_infect_by_idx}{}}}
\subsection{Method \code{seed_infect_by_idx()}}{
Infects a new individual from an external source.
Wrapper for C API \code{seed_infect_by_idx}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$seed_infect_by_idx(ID, strain_idx = 0, strain = NULL, network_id = -1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ID}}{The ID of the individual.}

\item{\code{strain_idx}}{The idx of the strain the person is infected with}

\item{\code{strain}}{\code{Strain} object.}

\item{\code{network_id}}{The network ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} on success, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_new_strain"></a>}}
\if{latex}{\out{\hypertarget{method-add_new_strain}{}}}
\subsection{Method \code{add_new_strain()}}{
Adds a new strain (variant)
Wrapper for C API \code{add_new_strain}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$add_new_strain(
  transmission_multiplier = 1,
  hospitalised_fraction = NA,
  hospitalised_fraction_multiplier = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{transmission_multiplier}}{The relative transmission rate of the strain}

\item{\code{hospitalised_fraction}}{the fraction of symptomatic (not mild) who progress to hospital [default: None is no change)]}

\item{\code{hospitalised_fraction_multiplier}}{The relative transmission rate of hospitalised patients.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{Strain} A Strain object representing this strain
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_cross_immunity_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-set_cross_immunity_matrix}{}}}
\subsection{Method \code{set_cross_immunity_matrix()}}{
Set the cross_immunity matrix
Wrapper for C API \code{set_cross_immunity_probability}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$set_cross_immunity_matrix(cross_immunity)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cross_immunity}}{the cross immunity matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_network_ids"></a>}}
\if{latex}{\out{\hypertarget{method-get_network_ids}{}}}
\subsection{Method \code{get_network_ids()}}{
Get the list of network IDs
Wrapper for C API \code{get_network_ids}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_network_ids()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list of the network IDs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_network_info"></a>}}
\if{latex}{\out{\hypertarget{method-get_network_info}{}}}
\subsection{Method \code{get_network_info()}}{
Get network info.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_network_info()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The network info as a dataframe. The columns are the network
properties and each row is a network.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_vaccine"></a>}}
\if{latex}{\out{\hypertarget{method-add_vaccine}{}}}
\subsection{Method \code{add_vaccine()}}{
Add a new vaccine.
Wrapper for C API \code{add_vaccine}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$add_vaccine(
  full_efficacy = 1,
  symptoms_efficacy = 1,
  severe_efficacy = 1,
  time_to_protect = 14,
  vaccine_protection_period = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{full_efficacy}}{Probability that the person is successfully vaccinated
(must be \code{0 <= efficacy <= 1}).}

\item{\code{symptoms_efficacy}}{Probability that the person is successfully vaccinated
against getting symptoms (must be \code{0 <= efficacy <= 1}).}

\item{\code{severe_efficacy}}{Probability that the person is successfully vaccinated
against getting severer symptoms (must be \code{0 <= efficacy <= 1}).}

\item{\code{time_to_protect}}{Delay before it takes effect (in days).}

\item{\code{vaccine_protection_period}}{The duration of the vaccine before it
wanes.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vaccine object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vaccinate_individual"></a>}}
\if{latex}{\out{\hypertarget{method-vaccinate_individual}{}}}
\subsection{Method \code{vaccinate_individual()}}{
Vaccinate an individual.
Wrapper for C API \code{intervention_vaccinate_by_idx}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$vaccinate_individual(ID, vaccine)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ID}}{The ID of the individual (must be \code{0 <= ID <= n_total}).}

\item{\code{vaccine}}{The of vaccine object to be given}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical value, \code{TRUE} if vaccinated \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vaccinate_schedule"></a>}}
\if{latex}{\out{\hypertarget{method-vaccinate_schedule}{}}}
\subsection{Method \code{vaccinate_schedule()}}{
Schedule an age-group vaccionation
Wrapper for C API \code{intervention_vaccinate_age_group}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$vaccinate_schedule(schedule)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{schedule}}{An instance of \code{\link{VaccineSchedule}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The total number of people vaccinated.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_individuals"></a>}}
\if{latex}{\out{\hypertarget{method-get_individuals}{}}}
\subsection{Method \code{get_individuals()}}{
Gets information about all individuals. Wrapper for
C API \code{get_individuals}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_individuals()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
DataFrame of basic individual information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_transmissions"></a>}}
\if{latex}{\out{\hypertarget{method-get_transmissions}{}}}
\subsection{Method \code{get_transmissions()}}{
Gets information about all transmission events. Wrapper for
C API \code{get_transmissions}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_transmissions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
DataFrame of transmission information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete_network"></a>}}
\if{latex}{\out{\hypertarget{method-delete_network}{}}}
\subsection{Method \code{delete_network()}}{
Delete a network.
Wrapper for C API \code{delete_network}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$delete_network(network)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network}}{The network to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} on success, \code{FALSE} on failure.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_app_users"></a>}}
\if{latex}{\out{\hypertarget{method-get_app_users}{}}}
\subsection{Method \code{get_app_users()}}{
Get all app users. Wrapper for C API \code{get_app_users}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$get_app_users()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
All app users.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_app_users"></a>}}
\if{latex}{\out{\hypertarget{method-set_app_users}{}}}
\subsection{Method \code{set_app_users()}}{
Sets specific users to have or not have the app.
Wrapper for C API \code{set_app_users}. Throws error on failure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$set_app_users(df_app_users)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{df_app_users}}{A dataframe which includes the names
\code{c("ID", "app_user")}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-one_time_step"></a>}}
\if{latex}{\out{\hypertarget{method-one_time_step}{}}}
\subsection{Method \code{one_time_step()}}{
Move the model through one time step.
Wrapper for C API \code{one_time_step}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$one_time_step()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-results"></a>}}
\if{latex}{\out{\hypertarget{method-results}{}}}
\subsection{Method \code{results()}}{
A dataframe of all the time-series results in the
simulation so far.Concatanates the return of one_time_step_results from
all steps so far.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$results()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A dataframe of the time-series results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run"></a>}}
\if{latex}{\out{\hypertarget{method-run}{}}}
\subsection{Method \code{run()}}{
Runs simulation to the end (specified by the parameter
end_time)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$run(n_steps = NULL, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n_steps}}{Number of simulation steps to run. \code{NULL} means that
the simulation runs until the end (\code{get_param("end_time")}).}

\item{\code{verbose}}{- whether to display progress information (DEFAULT=TRUE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Null
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-one_time_step_results"></a>}}
\if{latex}{\out{\hypertarget{method-one_time_step_results}{}}}
\subsection{Method \code{one_time_step_results()}}{
Get the results from one-time step.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$one_time_step_results()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector with names (i.e. dictionary).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_output_files"></a>}}
\if{latex}{\out{\hypertarget{method-write_output_files}{}}}
\subsection{Method \code{write_output_files()}}{
Write output files.
Wrapper for C API \code{write_output_files}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_output_files()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_individual_file"></a>}}
\if{latex}{\out{\hypertarget{method-write_individual_file}{}}}
\subsection{Method \code{write_individual_file()}}{
Write output files
Wrapper for C API \code{write_individual_file}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_individual_file()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_interactions_file"></a>}}
\if{latex}{\out{\hypertarget{method-write_interactions_file}{}}}
\subsection{Method \code{write_interactions_file()}}{
Wrapper for C API \code{write_interactions}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_interactions_file()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_trace_tokens_timeseries"></a>}}
\if{latex}{\out{\hypertarget{method-write_trace_tokens_timeseries}{}}}
\subsection{Method \code{write_trace_tokens_timeseries()}}{
Wrapper for C API \code{write_trace_tokens_ts}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_trace_tokens_timeseries(init = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{init}}{If \code{TRUE}, overwrite the output file and write the
column names at the start of the file. If \code{FALSE}, append a new
to the output file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_trace_tokens"></a>}}
\if{latex}{\out{\hypertarget{method-write_trace_tokens}{}}}
\subsection{Method \code{write_trace_tokens()}}{
Wrapper for C API \code{write_trace_tokens}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_trace_tokens()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_transmissions"></a>}}
\if{latex}{\out{\hypertarget{method-write_transmissions}{}}}
\subsection{Method \code{write_transmissions()}}{
Wrapper for C API \code{write_transmissions}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_transmissions()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_quarantine_reasons"></a>}}
\if{latex}{\out{\hypertarget{method-write_quarantine_reasons}{}}}
\subsection{Method \code{write_quarantine_reasons()}}{
Wrapper for C API \code{write_quarantine_reasons}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_quarantine_reasons()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_occupation_network"></a>}}
\if{latex}{\out{\hypertarget{method-write_occupation_network}{}}}
\subsection{Method \code{write_occupation_network()}}{
Wrapper for C API \code{write_occupation_network}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_occupation_network(idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{idx}}{Network index.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_household_network"></a>}}
\if{latex}{\out{\hypertarget{method-write_household_network}{}}}
\subsection{Method \code{write_household_network()}}{
Wrapper for C API \code{write_household_network}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_household_network()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-write_random_network"></a>}}
\if{latex}{\out{\hypertarget{method-write_random_network}{}}}
\subsection{Method \code{write_random_network()}}{
Wrapper for C API \code{write_random_network}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$write_random_network()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print_individual"></a>}}
\if{latex}{\out{\hypertarget{method-print_individual}{}}}
\subsection{Method \code{print_individual()}}{
Wrapper for C API \code{print_individual}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$print_individual(idx)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{idx}}{Individual index.}
}
\if{html}{\out{</div>}}
}
}
}
