% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenLand-package.R
\docType{package}
\name{OpenLand-package}
\alias{OpenLand-package}
\alias{OpenLand}
\title{OpenLand: land use and cover (LUC) time series analysis in R.}
\description{
OpenLand is an open-source R package for the analysis of land use and cover
(LUC) time series. It includes support for consistency check and loading
spatiotemporal raster data and synthesized spatial plotting. Several LUC change
(LUCC) metrics in regular or irregular time intervals can be extracted and
visualized through one- and multistep sankey and chord diagrams. A complete
intensity analysis according to \cite{(Aldwaik and Pontius, 2012)} is
implemented, including tools for the generation of standardized multilevel
output graphics.
}
\references{
Aldwaik, S. Z. and Pontius, R. G. (2012) ‘Intensity analysis to unify
measurements of size and stationarity of land changes by interval, category,
and transition, Landscape and Urban Planning. Elsevier B.V., 106(1), pp. 103–114.
\doi{10.1016/j.landurbplan.2012.02.010}.
}
\seealso{
The core functions in this package: \code{\link{intensityAnalysis}},
\code{\link{contingencyTable}},
}
\author{
Reginal Exavier \email{reginalexavier@rocketmail.com}, Peter Zeilhofer \email{zeilhoferpeter@gmail.com}
}
