% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demolandscape.R
\name{.demo_landscape}
\alias{.demo_landscape}
\title{Create Raster with Random pixel Value}
\usage{
.demo_landscape(
  year,
  nrows = 100,
  ncols = 100,
  res = 1,
  xmn = 0,
  xmx = 100,
  ymn = 0,
  ymx = 100,
  crs = NA,
  category = 1:5,
  prob = NULL
)
}
\arguments{
\item{year}{numeric. A vector of year, first and last included.}

\item{nrows}{numeric. nrows of the raster to be created.}

\item{ncols}{numeric. ncols of the raster to be created.}

\item{res}{numeric. the resolution of the raster to be created.}

\item{xmn}{numeric. x minimum extent.}

\item{xmx}{numeric. x maximum extent.}

\item{ymn}{numeric. y minimum extent.}

\item{ymx}{numeric. y maximum extent.}

\item{crs}{character. the coordinate referencing system.}

\item{category}{A numeric vector of the raster categories.}

\item{prob}{A numreric vector of the probability of occurrence for the
category list.}
}
\value{
list
}
\description{
This function create a raster serie with some setup like the layer name and
the sample value for the lulc
}
\examples{
.demo_landscape(year =  2000:2005,
                res = 1,
                crs = "+proj=utm +zone=21 +south +ellps=GRS80 +units=m +no_defs")

}
\seealso{
\code{\link[raster]{raster}}
}
\keyword{internal}
