% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxCompute.R
\name{mxComputeGradientDescent}
\alias{mxComputeGradientDescent}
\alias{MxComputeGradientDescent-class}
\title{Optimize parameters using a gradient descent optimizer}
\usage{
mxComputeGradientDescent(freeSet = NA_character_, ..., engine = NULL,
  fitfunction = "fitfunction", verbose = 0L, tolerance = NA_real_,
  useGradient = NULL, warmStart = NULL, nudgeZeroStarts = mxOption(NULL,
  "Nudge zero starts"), maxMajorIter = NULL, gradientAlgo = mxOption(NULL,
  "Gradient algorithm"),
  gradientIterations = imxAutoOptionValue("Gradient iterations"),
  gradientStepSize = imxAutoOptionValue("Gradient step size"))
}
\arguments{
\item{freeSet}{names of matrices containing free parameters.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{engine}{specific 'CSOLNP', 'SLSQP', or 'NPSOL'}

\item{fitfunction}{name of the fitfunction (defaults to 'fitfunction')}

\item{verbose}{level of debugging output}

\item{tolerance}{how close to the optimum is close enough (also known as the optimality tolerance)}

\item{useGradient}{whether to use the analytic gradient (if available)}

\item{warmStart}{a Cholesky factored Hessian to use as the NPSOL Hessian starting value (preconditioner)}

\item{nudgeZeroStarts}{whether to nudge any zero starting values prior to optimization (default TRUE)}

\item{maxMajorIter}{maximum number of major iterations}

\item{gradientAlgo}{one of c('forward','central')}

\item{gradientIterations}{number of Richardson iterations to use for the gradient}

\item{gradientStepSize}{the step size for the gradient}
}
\description{
This optimizer does not require analytic derivatives of the fit
function. The fully open-source CRAN version of OpenMx offers 2 choices,
CSOLNP and SLSQP (from the NLOPT collection).  The OpenMx Team's version of
OpenMx offers the choice of three optimizers: CSOLNP, SLSQP, and NPSOL.
}
\details{
One option for CSOLNP and SLSQP is
\code{gradientAlgo}. CSOLNP uses \code{forward} method
by default, while SLSQP uses \code{central} method. \code{forward} method requires
1 time \code{gradientIterations} function evaluation per parameter
per gradient, while \code{central} method requires 2 times
\code{gradientIterations} function evaluations per parameter 
per gradient. Users can change the default methods for either of these optimizers.
NPSOL usually uses the \code{forward} method, but
adaptively switches to \code{central} under certain circumstances.

CSOLNP uses the value of argument \code{gradientStepSize} as-is, 
whereas SLSQP internally scales it by a factor of 100. The
purpose of this transformation is to obtain roughly the same
accuracy given other differences in numerical procedure.
NPSOL ignores \code{gradientStepSize}, and instead uses a function
of \link{mxOption} \dQuote{Function precision} to determine its gradient
step size.

All three optimizers can use analytic gradients,
and only NPSOL uses \code{warmStart}.
}
\examples{
data(demoOneFactor)
factorModel <- mxModel(name ="One Factor",
  mxMatrix(type="Full", nrow=5, ncol=1, free=FALSE, values=0.2, name="A"),
    mxMatrix(type="Symm", nrow=1, ncol=1, free=FALSE, values=1, name="L"),
    mxMatrix(type="Diag", nrow=5, ncol=5, free=TRUE, values=1, name="U"),
    mxAlgebra(expression=A \%*\% L \%*\% t(A) + U, name="R"),
  mxExpectationNormal(covariance="R", dimnames=names(demoOneFactor)),
  mxFitFunctionML(),
    mxData(observed=cov(demoOneFactor), type="cov", numObs=500),
     mxComputeSequence(steps=list(
     mxComputeGradientDescent(),
     mxComputeNumericDeriv(),
     mxComputeStandardError(),
     mxComputeHessianQuality()
    )))
factorModelFit <- mxRun(factorModel)
factorModelFit$output$conditionNumber # 29.5
}
\references{
Luenberger, D. G. & Ye, Y. (2008). \emph{Linear and nonlinear programming.} Springer.
}
