% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_wave.R
\name{adj_wave}
\alias{adj_wave}
\alias{adj_wave.default}
\alias{adj_wave.OpenSpecy}
\title{Adjust wavelength to wavenumbers for Raman}
\usage{
adj_wave(x, ...)

\method{adj_wave}{default}(x, laser, ...)

\method{adj_wave}{OpenSpecy}(x, laser, ...)
}
\arguments{
\item{x}{an \code{OpenSpecy} object with wavenumber units specified as
wavelength in nm or a wavelength vector.}

\item{laser}{the wavelength in nm of the Raman laser.}

\item{\ldots}{additional arguments passed to submethods.}
}
\value{
An \code{OpenSpecy} object with new units converted from wavelength
to wavenumbers or a vector with the same conversion.
}
\description{
Functions for converting between wave* units.
}
\examples{
data("raman_hdpe")
raman_wavelength <- raman_hdpe
raman_wavelength$wavenumber <- (-1*(raman_wavelength$wavenumber/10^7-1/530))^(-1)
adj_wave(raman_wavelength, laser = 530)
adj_wave(raman_wavelength$wavenumber, laser = 530)

}
\author{
Win Cowger, Zacharias Steinmetz
}
