#!/usr/bin/R
#contributors = c("Michael Gruenstaeudl","Nils Jenke")
#email = "m.gruenstaeudl@fu-berlin.de", "nilsj24@zedat.fu-berlin.de"
#version = "2019.09.13.1800"

filter <- function(allRegions_L, where) {
  out = subset(allRegions_L, grepl("IRb|IRa|repeat|inverted", allRegions_L[,where], ignore.case = FALSE))
  if (nrow(out) < 1) {
      warning(paste("Inverted repeat info not found for qualifier ", where, ".", sep=""))
      }
  return(out)
}

ExtractAllRegions <- function(gbkData) {
  # Function to extract specific regions from Genbank input data
  # ARGS:
  #   gbkData: Genbank input data parsed by genbankr
  # RETURNS:
  #   regions in data frame format
  allRegions_L <- BiocGenerics::as.data.frame(genbankr::otherFeatures(gbkData))
  region_L <- tryCatch(filter(allRegions_L,"note"), warning = function(w) filter(allRegions_L,"standard_name"))
  if (nrow(region_L) > 2) {
    region_L <- region_L[order(region_L[,4],decreasing = TRUE),]
    region_L <- region_L[1:2,]
  }
  if (nrow(region_L) != 2) {
    warning("Number of inverted repeats not equal to 2.")
    stop()
  }
  region_L <- region_L[,1:3]
  region_L <- region_L[order(region_L[,3],decreasing = FALSE),]
  region_L[1] <- c("IRb","IRa")
  LSC <- c(1,region_L[1,2]-1)
  SSC <- c(region_L[1,3]+1,region_L[2,2]-1)
  region_L[3, ] <- c("LSC", LSC)
  region_L[4, ] <- c("SSC", SSC)
  region_L[ ,2] <- as.integer(region_L[ ,2])
  region_L[ ,3] <- as.integer(region_L[ ,3])
  region_L <- region_L[order(region_L[ ,3], decreasing = FALSE), ]
  if (nrow(region_L) != 4) {
    warning("Insufficient regions in the input genome detected. Please note: The Genbank record must at least contain note-qualifiers for the inverted repeats.")
    stop()
  }
  #region_L <- cbind(region_L, Band  = c("","","",""), Stain = c("","","",""))
  region_L <- cbind(region_L, Band  = c("","","",""), Stain = c("gneg","gneg","gneg","gneg"))
  region_L <- Rename_Df(region_L, c("Band","Stain"))
  return(region_L)
}
