% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateMetadata.R
\name{annotateMetadata}
\alias{annotateMetadata}
\title{annotateMetadata Function}
\usage{
annotateMetadata(
  data_object,
  sample_column = "Sample",
  donor_column = "PTID",
  time_column = "Time",
  group_column = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. Contains annotation table
and expression matrix or data frame. Rows represent gene/proteins column
represents participant samples (same as annotation table Sample column)}

\item{sample_column}{Name of Sample column in user input annotation data
frame. Default 'Sample'}

\item{donor_column}{Name of Donor/participant column in user input annotation
data frame. Default 'PTID'}

\item{time_column}{Name of Time column in user input annotation data
frame. Default 'Time'}

\item{group_column}{Optional. Calculate average expression by given group
like 'celltype' or 'cluster'}
}
\value{
PALMO object
}
\description{
This function allows to add user-defined sample, participant, and time column
to a PALMO object in standard format.
}
\examples{
\dontrun{
annotateMetadata(data_object=palmo_obj, sample_column='Sample',
donor_column='PTID', time_column='Time')
}
}
\keyword{annotateMetadata}
