% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addFunction.R
\name{addFunction}
\alias{addFunction}
\title{Add a Function to a PAMpalSettings Object}
\usage{
addFunction(pps, fun, module = NULL, verbose = TRUE, ...)
}
\arguments{
\item{pps}{a \linkS4class{PAMpalSettings} object to add a function to}

\item{fun}{function to add OR another \linkS4class{PAMpalSettings} object.
In this case all functions from the second object will be added to \code{pps}}

\item{module}{Pamguard module output this function should act on, one of
ClickDetector, WhistlesMoans, or Cepstrum. If \code{NULL} (default), user
will be prompted to select which module it applies to}

\item{verbose}{logical flag to show messages}

\item{\dots}{named arguments to pass to function being added}
}
\value{
the same \linkS4class{PAMpalSettings} object as pps, with the function
  \code{fun} added to the "functions" slot
}
\description{
Adds a new function to the "function" slot in a PAMpalSettings
  object. Must be run interactively, user will be prompted to assign
  values for any parameters in the function to be added
}
\examples{

# not recommended to create a pps like this, for example only
pps <- new('PAMpalSettings')
if(interactive()) pps <- addFunction(pps, standardClickCalcs)
pps <- addFunction(pps, roccaWhistleCalcs, module='WhistlesMoans')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
