% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAIS.R
\name{addAIS}
\alias{addAIS}
\title{Add AIS Data to Dataframe}
\usage{
addAIS(
  x,
  ais,
  interpType = c("all", "close", "none"),
  interpTime = 0,
  interpCols = NULL
)
}
\arguments{
\item{x}{a dataframe with \code{UTC}, \code{Latitude}, and \code{Longitude}
columns}

\item{ais}{AIS data created using the \link{readLocalAIS} function}

\item{interpType}{one of \code{c('all', 'close', 'none')}, the type
of time interpolation to apply to \code{x}. Often the time scale of points
in \code{x} is much longer than the points in \code{ais}, which can result
in awkward looking AIS paths. \code{'all'} will interpolate all points in
\code{x} to a smaller timescale. \code{'close'} will interpolate only
time ranges in \code{ais} marked as \code{inDist} by \link{readLocalAIS}.
\code{'none'} will apply no interpolation}

\item{interpTime}{time (seconds) between new \code{UTC} points. If
\code{0} (default), no interpolation will be done}

\item{interpCols}{names of any extra columns to interpolate (other than
\code{Latitude} and \code{Longitude})}
}
\value{
a dataframe with AIS data added, will contain more rows than \code{x}
if \code{ais} has more than one vessel. If any interpolation is applied,
any non-constant columns not specified to \code{interpCols} will be removed
}
\description{
Adds matching AIS data downloaded from Marine Cadastre
to a dataframe containing location information
}
\examples{
gps <- data.frame(Latitude=c(33.2, 33.5,33.6),
                  Longitude=c(-118.1, -118.4, -119),
                  UTC=as.POSIXct(
                    c('2022-04-28 05:00:00',
                      '2022-04-28 10:00:00',
                      '2022-04-28 20:00:00'),
                    tz='UTC'))
ais <- readLocalAIS(gps, aisDir=system.file('extdata/ais', package='PAMscapes'), distance=20e3)
gpsNoInterp <- addAIS(gps, ais, interpType='none')
str(gpsNoInterp)
gpsClose <- addAIS(gps, ais, interpType='close')
str(gpsClose)
gpsAllInterp <- addAIS(gps, ais, interpType='all')
str(gpsAllInterp)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
