% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetMarCadAIS.R
\name{subsetMarCadAIS}
\alias{subsetMarCadAIS}
\title{Subset Marine Cadastre AIS Data to Region}
\usage{
subsetMarCadAIS(
  inDir,
  outDir,
  latRange = c(20, 50),
  lonRange = c(-140, -110),
  name = "West_",
  overwrite = FALSE,
  progress = TRUE
)
}
\arguments{
\item{inDir}{directory containing Marine Cadastre AIS CSV files to subset}

\item{outDir}{directory to write subsetted files to}

\item{latRange}{range of desired latitudes (decimal degrees)}

\item{lonRange}{range of desired longitudes (decimal degrees)}

\item{name}{prefix to append to new filenames}

\item{overwrite}{logical flag to overwrite existing files}

\item{progress}{logical flag to show progress bar}
}
\value{
invisibly return new file names
}
\description{
Subsets the full download files from Marine Cadastre to a
smaller region so that they are easier to work with
}
\examples{

\donttest{
outDir <- tempdir()
localFiles <- subsetMarCadAIS('AISData', outDir=outDir,
                              latRange=c(20, 50), lonRange=c(-140, -110),
                              name='West_')
}

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
