#' @title A matrix of partial regression plots between responses after adjustments
#'
#' @description A plot matrix to display the results of partial association analyses.
#' Upper-triangle contains scatter-plot matrix between each pair of response variables.
#' Lower-triangle contains the partial correlation coefficients adjusted by covariates.
#'
#' @details A pairwise plot matrix reveals the partial association between ordinal variables.
#' All the plots are based on surrogate residuals generated from \code{"resides"} function.
#' Graphics are designed based on \code{\link{ggplot2}} and \code{"GGally"}.
#'
#' @param x The object in "PAsso" class that is generated by "PAsso" or "test".
#' @param color The color of points.
#' @param ... Additional optional arguments to be passed onto.
#' @param shape The shapre of points. For more details see the help vignette:
#' \code{vignette("ggplot2-specs", package = "ggplot2")}
#' @param size The size of points. For more details see the help vignette:
#' \code{vignette("ggplot2-specs", package = "ggplot2")}
#' @param alpha The value to make the points transparent. For more details see the help vignette:
#' \code{vignette("ggplot2-specs", package = "ggplot2")}
#'
#' @return A \code{"GGally"} object.
#'
#' @importFrom GGally ggpairs wrap
#'
#' @name plot
#' @method plot PAsso
#' @export
#'
#' @examples
#' data(ANES2016)
#'
#' summary(ANES2016)
#'
#' PAsso_2v <- PAsso(responses = c("PreVote.num", "PID"),
#'                  adjustments = c("income.num", "age", "edu.year"),
#'                  data = ANES2016)
#'
#' plot(PAsso_2v)
#'
plot.PAsso <- function(
  x, color="#444444",
  shape = 19, size = 2, alpha = 0.5,
  ...
) {
  resid_Mat <- as.data.frame(x$rep_SRs[,1,])
  cor_method <- attr(x, "arguments")[2]
  if (cor_method == "wolfsigma") { # wolfsigma only return one value!
    stop("Please use plot3D() to display the 'wolfsigma' correlation")
  } else {
    ggpairs(resid_Mat,
            upper = list(
              continuous = wrap("smooth_loess", colour=color,
                                shape = shape, size = size, alpha = alpha,
                                ...)),
            # diag = list(continuous = wrap("barDiag", colour = color)),
            # lower = list(continuous = GGally::wrap("cor", method="kendall")),
            lower = list(continuous = wrap("cor", method = cor_method, ...)),
            # lower = list(continuous = x$corr[upper.tri(x$corr)]),
            ...
    )
  }
}

