% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_transition_info.R
\name{get_transition_info}
\alias{get_transition_info}
\title{Convert a set of predicted and actual activity transitions to an object that
can be analyzed}
\usage{
get_transition_info(predictions, references, window_size = 1, ...)
}
\arguments{
\item{predictions}{A dummy-coded vector of predicted transitions (1)
interspersed with non-transitions (0)}

\item{references}{A dummy-coded vector of actual (i.e., reference)
transitions (1) interspersed with non-transitions (0)}

\item{window_size}{The maximum number of indices that are allowed to separate
a predicted and reference transition, before the two are considered
incompatible}

\item{...}{additional arguments passed to or from methods, not currently used}
}
\value{
an object of class \code{transition} that contains necessary
  information for evaluating the effectiveness of the predictions.
}
\description{
Convert a set of predicted and actual activity transitions to an object that
can be analyzed
}
\examples{
predictions <- sample(c(0,1), 100, TRUE, c(3, 1))
references  <- sample(c(0,1), 100, TRUE, c(4,1))
get_transition_info(predictions, references, 10)
}
