% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmr_sliding.R
\name{rmr_sliding}
\alias{rmr_sliding}
\title{Calculate resting metabolic rate using a sliding window method}
\usage{
rmr_sliding(vo2_values, vo2_timestamps, start_time, stop_time,
  window_size_minutes = 5)
}
\arguments{
\item{vo2_values}{numeric vector of oxygen consumption values}

\item{vo2_timestamps}{timestamps corresponding to each element of
\code{vo2_values}}

\item{start_time}{the beginning time of the assessment period}

\item{stop_time}{the ending time of the assessment period}

\item{window_size_minutes}{the size of the sliding window, in minutes}
}
\value{
A data frame giving the oxygen consumption from the lowest window, as
  well as the time difference from first to last breath in the same window.
}
\description{
Calculate resting metabolic rate using a sliding window method
}
\examples{
set.seed(144)
fake_start_time <- Sys.time()
fake_stop_time <- fake_start_time + 1800
fake_timestamps <- fake_start_time + cumsum(sample(1:3, 500, TRUE))
fake_timestamps <- fake_timestamps[fake_timestamps <= fake_stop_time]
fake_breaths <- rnorm(length(fake_timestamps), 450, 0.5)
window_size <- 5

rmr_sliding(
  fake_breaths, fake_timestamps,
  fake_start_time, fake_stop_time,
  window_size
)
}
