% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_preferences_utils.R
\name{dim_check}
\alias{dim_check}
\alias{prune_prefs}
\title{Account for cases that refuse all matches}
\usage{
dim_check(x)

prune_prefs(prefs)
}
\arguments{
\item{prefs}{an object passed from \code{\link{get_preferences}}}
}
\value{
A pruned list of matrices containing only cases with at least one
  possible match
}
\description{
To run the college admissions algorithm, it is assumed that each
student/college has at least one possible match. In the activity transition
application, possible matches are restricted to "nearby" cases, i.e. within
some specified \code{window_size}. Thus, if there are no matches close by,
there are no possible matches, and the case needs to be removed from the
analysis in the college admissions algorithm. It needs to be re-inserted
afterwards and labeled as a false positive or false negative, depending on
whether it was a college (i.e., a predicted transition) or a student (i.e.,
an actual transition), respectively.
}
\keyword{internal}
