% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paired_equivalence_wrapper.R
\name{paired_equivalence_wrapper}
\alias{paired_equivalence_wrapper}
\title{A template function for conducting a paired equivalence test}
\usage{
paired_equivalence_wrapper(
  x,
  y,
  y_type,
  width,
  epsilon,
  alpha,
  scale,
  na.rm,
  do_test = TRUE
)
}
\arguments{
\item{x}{numeric vector representing the (possibly surrogate) sample}

\item{y}{numeric vector representing the (possibly criterion) sample. Index
paired with \code{x}}

\item{y_type}{classification of \code{y} for the purpose of analysis. Can be
\code{"criterion"}, \code{"comparison"}, or \code{"both"}.}

\item{width}{the user-specified width of the equivalence region, possibly a
proportion of an initially-uncalculated mean}

\item{epsilon}{the calculated width of the equivalence region}

\item{alpha}{the alpha level for the test}

\item{scale}{character specifying whether the test should occur on an
absolute or relative scale. Must be one of \code{"relative"} (default) or
\code{"absolute"}.}

\item{na.rm}{logical. Omit mean values for mean calculations?}

\item{do_test}{logical. Complete the test? Enables premature return that is
useful in some cases}
}
\description{
A template function for conducting a paired equivalence test
}
\keyword{internal}
