% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCM.R
\name{MatchListMembers}
\alias{MatchListMembers}
\title{Find the members in a list matching a member expression}
\usage{
MatchListMembers(object, member, enclos = "?", q = "'", ...)
}
\arguments{
\item{object}{a list containing named elements.}

\item{member}{a member expression. Member expressions are character strings
denoting named elements in a list object (see examples).}

\item{enclos}{a character string containing the special symbol '?'. This
symbol is to be replaced by matching expressions. The result of this
substitution can be anything but, usually would be a valid R expression.
Default: "?".}

\item{q}{a quote symbol, Default: \code{"'"}.}

\item{...}{additional arguments passed to \code{\link{grep}}. For example,
these could be \code{ignore.case=TRUE} or \code{perl=TRUE}.}
}
\value{
a named character vector, with names corresponding to the matched
member quoted expressions (using the argument \code{q} as a quote symbol),
and values corresponding to the '\code{enclos}-ed' expressions after
substituting the '?'.
}
\description{
Find the members in a list matching a member expression
}
\examples{
model <- PCMBaseTestObjects$model_MixedGaussian_ab
MatchListMembers(model, "Sigma_x", "diag(model?[,,1L])")
MatchListMembers(model, "S.*_x", "diag(model?[,,1L])")
MatchListMembers(model, "Sigma_x", "model?[,,1L][upper.tri(model?[,,1L])]")
MatchListMembers(model, "a$Sigma_x", "model?[,,1L][upper.tri(model?[,,1L])]")

}
\seealso{
\code{\link{PCMListMembers}}
}
