% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeSetPartition}
\alias{PCMTreeSetPartition}
\title{Set a partition of a tree by specifying the partition nodes}
\usage{
PCMTreeSetPartition(tree, nodes = c(PCMTreeNumTips(tree) + 1L), inplace = TRUE)
}
\arguments{
\item{tree}{a PCMTree object.}

\item{nodes}{a character vector containing tip or node labels or an integer
vector denoting tip or internal nodes in tree - the parts change at the
start of the branches leading to these nodes. Default:
c(PCMTreeNumTips(tree) + 1L).}

\item{inplace}{a logical indicating if the change should be done to the tree
in the calling environment (TRUE) or a copy of the tree with set edge.part
member should be returned (FALSE). Default is TRUE.}
}
\value{
If inplace is TRUE nothing, otherwise a copy of the tree with set
edge.part member.
}
\description{
Set a partition of a tree by specifying the partition nodes
}
\examples{
set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
tree <- PCMTree(ape::rtree(8))
PCMTreeSetLabels(tree, paste0("x", PCMTreeGetLabels(tree)))
PCMTreeGetPartition(tree)
PCMTreeGetPartNames(tree)
PCMTreeGetPartRegimes(tree)
\donttest{
PCMTreePlot(tree) + ggtree::geom_nodelab() + ggtree::geom_tiplab()
}
tree <- PCMTreeSetPartition(tree, c(12, 14), inplace = FALSE)
PCMTreeGetPartition(tree)
PCMTreeGetPartNames(tree)
PCMTreeGetPartRegimes(tree)
\donttest{
PCMTreePlot(tree) + ggtree::geom_nodelab() + ggtree::geom_tiplab()
}

# reset the partition to a default one, where there is only one part:
PCMTreeSetPartition(tree)

PCMTreeGetPartition(tree)
PCMTreeGetPartNames(tree)
PCMTreeGetPartRegimes(tree)
\donttest{
PCMTreePlot(tree) + ggtree::geom_nodelab() + ggtree::geom_tiplab()
}

# reset the labels to the default labels which are character representations
# of the node ids
PCMTreeSetLabels(tree)
PCMTreeGetPartition(tree)
PCMTreeGetPartNames(tree)
PCMTreeGetPartRegimes(tree)

}
\seealso{
\code{\link{PCMTreeGetPartition}}

\code{\link{PCMTree}}
}
