% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianPCM.R
\name{PCMCondVOU}
\alias{PCMCondVOU}
\title{Variance-covariance matrix of an OU process with optional measurement error and jump at the start}
\usage{
PCMCondVOU(H, Sigma, Sigmae = NULL, Sigmaj = NULL, xi = NULL,
  e_Ht = NULL,
  threshold.Lambda_ij = getOption("PCMBase.Threshold.Lambda_ij", 1e-08))
}
\arguments{
\item{H}{a numerical k x k matrix - selection strength parameter.}

\item{Sigma}{a numerical k x k matrix - neutral drift unit-time variance-covariance matrix.}

\item{Sigmae}{a numerical k x k matrix - environmental variance-covariance matrix.}

\item{Sigmaj}{is the variance matrix of the normal jump distribution (default is NULL).}

\item{xi}{a vector of 0's and 1's corresponding to each branch in the tree. A value of 1
indicates that a jump takes place at the beginning of the branch. This arugment is only
used if Sigmaj is not NULL. Default is NULL.}

\item{e_Ht}{a numerical k x k matrix - the result of the matrix exponential expm(-t*H).}

\item{threshold.Lambda_ij}{a 0-threshold for abs(Lambda_i + Lambda_j), where Lambda_i
and Lambda_j are eigenvalues of the parameter matrix H. This threshold-values is used as
a condition to take the limit time of the expression `(1-exp(-Lambda_ij*time))/Lambda_ij`
as `(Lambda_i+Lambda_j) --> 0`. You can control this value by the global option
"PCMBase.Threshold.Lambda_ij". The default value (1e-8) is suitable for branch lengths
bigger than 1e-6. For smaller branch lengths, you may want to increase the threshold
value using, e.g.  `options(PCMBase.Threshold.Lambda_ij=1e-6)`.}
}
\value{
a function of one numerical argument (time) and an integer indicating the branch-index
that is used to check the corresponding element in xi.
}
\description{
Variance-covariance matrix of an OU process with optional measurement error and jump at the start
}
