% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathEfrontRisky.R
\name{mathEfrontRisky}
\alias{mathEfrontRisky}
\title{Efficient Frontier of Risky Stocks}
\usage{
mathEfrontRisky(
  returns,
  npoints = 100,
  efront.only = TRUE,
  display = TRUE,
  cexGmv = 0.9,
  pchPoints = 20,
  cexPoints = 1,
  cexText = 0.7,
  values = FALSE,
  digits = NULL
)
}
\arguments{
\item{returns}{Multivariate xts object of portfolio returns}

\item{npoints}{Integer number of efficient frontier points, with default 100}

\item{efront.only}{Logical variable with default TRUE}

\item{display}{If TRUE the efficient frontier is plotted}

\item{cexGmv}{A size parameter for the text "GMV"}

\item{pchPoints}{A parameter of the type of points}

\item{cexPoints}{A size parameter of points}

\item{cexText}{A size parameter of text}

\item{values}{Logical variable with default TRUE}

\item{digits}{Integer variable number of significant digits, default NULL}
}
\value{
no values are returned by default, and a plot is displayed of the
either the risky assets only efficient frontier, or the entire frontier.
Optionally, the values of the mean and volatility along the efficient
frontier are returned.
}
\description{
Computes and plots the efficient frontier of risky assets
only, using a multivariate time series of returns to compute the mean
vector and covariance matrix
}
\details{
When efront.only = TRUE only the efficient frontier is computed,
and if FALSE the entire frontier is computed.  When value = TRUE the
efficient frontier mean and volatility values are returned, and when
value = FALSE these values are not returned.
}
\examples{
args(mathEfrontRisky)
}
