% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.R
\name{pk.calc.sparse_auc}
\alias{pk.calc.sparse_auc}
\alias{pk.calc.sparse_auclast}
\title{Calculate AUC and related parameters using sparse NCA methods}
\usage{
pk.calc.sparse_auc(
  conc,
  time,
  subject,
  method = NULL,
  auc.type = "AUClast",
  ...,
  options = list()
)

pk.calc.sparse_auclast(conc, time, subject, ..., options = list())
}
\arguments{
\item{conc}{Measured concentrations}

\item{time}{Time of the measurement of the concentrations}

\item{subject}{Subject identifiers (may be any class; may not be null)}

\item{method}{The method for integration (one of 'lin up/log down',
'lin-log', or 'linear')}

\item{auc.type}{The type of AUC to compute.  Choices are 'AUCinf', 'AUClast',
and 'AUCall'.}

\item{...}{For functions other than \code{pk.calc.auxc}, these values are passed
to \code{pk.calc.auxc}}

\item{options}{List of changes to the default PKNCA options (see
\code{PKNCA.options()})}
}
\description{
The AUC is calculated as:
}
\details{
\deqn{AUC=\sum\limits_{i} w_i \bar{C}_i}{AUC = sum(w_i * Cbar_i)}

Where:

\describe{
\item{\eqn{AUC}{AUC}}{is the estimated area under the concentration-time curve}
\item{\eqn{w_i}{w_i}}{is the weight applied to the concentration at time i (related to the time which it affects, see \code{\link[=sparse_auc_weight_linear]{sparse_auc_weight_linear()}})}
\item{\eqn{\bar{C}_i}{Cbar_i}}{is the average concentration at time i}
}
}
\section{Functions}{
\itemize{
\item \code{pk.calc.sparse_auclast()}: Compute the AUClast for sparse PK

}}
\seealso{
Other Sparse Methods: 
\code{\link{as_sparse_pk}()},
\code{\link{sparse_auc_weight_linear}()},
\code{\link{sparse_mean}()}
}
\concept{Sparse Methods}
