% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.intervals.R
\name{check.interval.specification}
\alias{check.interval.specification}
\title{Check the formatting of a calculation interval specification data
frame.}
\usage{
check.interval.specification(x)
}
\arguments{
\item{x}{The data frame specifying what to calculate during each
time interval}
}
\value{
x The potentially updated data frame with the interval
calculation specification.
}
\description{
Calculation interval specifications are data frames defining what
calculations will be required and summarized from all time
intervals.  Note: parameters which are not requested may be
calculated if it is required for (or computed at the same time as)
a requested parameter.
}
\details{
The data frame columns (with variable type in parentheses) are:
\describe{
  \item{\code{start}}{The starting time (numeric)}
  \item{\code{end}}{The ending time (numeric including Inf)}
  \item{\code{aucinf}}{Compute AUCinf (logical)}
  \item{\code{auclast}}{Compute AUClast (logical)}
  \item{\code{aucall}}{Compute AUCall (logical)}
  \item{\code{aumcinf}}{Compute AUMCinf (logical)}
  \item{\code{aumclast}}{Compute AUMClast (logical)}
  \item{\code{aumcall}}{Compute AUMCall (logical)}
  \item{\code{tfirst}}{The time of the first concentration above the limit
    of quantification (logical)}
  \item{\code{tmax}}{The time of observed maximum concentration (logical)}
  \item{\code{tlast}}{The time of the last concentration above the limit
    of quantification (logical)}
  \item{\code{cmin}}{The observed minimum concentration during the interval
    (logical)}
  \item{\code{cmax}}{The observed maximum concentration (logical)}
  \item{\code{clast.obs}}{The observed last concentration (logical)}
  \item{\code{clast.pred}}{The concentration at \code{tlast} predicted by
    the half life (logical)}
  \item{\code{half.life}}{The half-life (logical)}
  \item{\code{thalf.eff}}{The effective half-life (logical)}
  \item{\code{aucpext}}{The percent of the AUCinf that is extrapolated after
    the AUClast (logical)}
  \item{\code{cl}}{The clearance (force: 'force' indicates that
    clearance should be calculated even if it is a multiple-dose study
    and the drug has not reached steady-state.)}
  \item{\code{mrt}}{The mean residence time (logical)}
  \item{\code{vz}}{Terminal volume of distribution (logical)}
  \item{\code{vss}}{Steady-state volume of distribution (logical)}
}

The variable types for each column are:
\describe{
  \item{logical}{A logical variable.}
  \item{numeric}{A numeric (non-factor) column}
  \item{force}{logical or the text \code{'force'}.  \code{'force'}
    indicates that checking if the calculation is appropriate should be
    skipped.}
  \item{character or factor}{The text suggested as either a character or
    a factor}
}

\code{start} and \code{end} time must always be given, and the
\code{start} must be before the \code{end}.
}
\seealso{
\code{\link{check.interval.deps}}
}

