% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.classes.R
\name{PKNCAdata}
\alias{PKNCAdata}
\title{Create a PKNCAdata object.}
\usage{
PKNCAdata(data.conc, formula.conc, data.dose, formula.dose, intervals,
  options = list())
}
\arguments{
\item{data.conc}{Concentration data as a \code{PKNCAconc} object or
a data frame}

\item{formula.conc}{Formula for making a \code{PKNCAconc} object
with \code{data.conc}.  This must be given if \code{data.conc} is a
data.frame, and it must not be given if \code{data.conc} is a
\code{PKNCAconc} object.}

\item{data.dose}{Dosing data as a \code{PKNCAdose} object}

\item{formula.dose}{Formula for making a \code{PKNCAdose} object
with \code{data.dose}.  This must be given if \code{data.dose} is a
data.frame, and it must not be given if \code{data.dose} is a
\code{PKNCAdose} object.}

\item{intervals}{A data frame with the AUC interval specifications
as defined in \code{\link{check.interval.specification}}.  If
missing, this will be automatically chosen by
\code{\link{choose.auc.intervals}}.}

\item{options}{List of changes to the default
\code{\link{PKNCA.options}} for calculations.}
}
\value{
A PKNCAdata object with concentration, dose, interval, and
calculation options stored (note that PKNCAdata objects can also
have results after a NCA calculations are done to the data).
}
\description{
\code{PKNCAdata} combines \code{PKNCAconc} and \code{PKNCAdose} and
adds in the intervals for PK calculations.
}
\seealso{
\code{\link{PKNCAconc}}, \code{\link{PKNCAdose}},
\code{\link{choose.auc.intervals}}
}

