% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixr_parse_parameters.R
\name{nlmixr_parse_parameters}
\alias{nlmixr_parse_parameters}
\title{Function to parse parameters for a model into a structure used by nlmixr}
\usage{
nlmixr_parse_parameters(
  parameters = list(CL = 5, V = 50),
  omega = c(0.1, 0.05, 0.1),
  res_var = list(prop = 0.1, add = 1),
  fixed = c(),
  log_transform = TRUE,
  ...
)
}
\arguments{
\item{parameters}{list of parameters}

\item{omega}{vector describing the lower-diagonal of the between-subject variability matrix}

\item{res_var}{residual variability. Expected a list with arguments `prop`, `add`, and/or `exp`. NULL by default.}

\item{fixed}{vector of fixed parameters}

\item{log_transform}{log-transform estimated parameters in nlmixr?}

\item{...}{passed on}
}
\value{
List of parameters that can be used by nlmixr
}
\description{
Function to parse parameters for a model into a structure used by nlmixr
}
