% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoComp_Coefficient_Exponent.R
\name{TwoComp_Coefficient_Exponent}
\alias{TwoComp_Coefficient_Exponent}
\title{Convert pharmacokinetic parameters for two compartment model}
\usage{
TwoComp_Coefficient_Exponent(A,B,alpha,beta,
 A.sd=NA,B.sd=NA,alpha.sd=NA,beta.sd=NA,
 covar=c(AB=NA,Aalpha=NA,Abeta=NA,Balpha=NA,Bbeta=NA,alphabeta=NA))
}
\arguments{
\item{A}{parameter in one compartment model "Aexp(-alpha)"}

\item{B}{parameter in two compartment model "Aexp(-alpha)+Bexp(-beta)"}

\item{alpha}{parameter in one compartment model "Aexp(-alpha)"}

\item{beta}{parameter in two compartment model "Aexp(-alpha)+Bexp(-beta)"}

\item{A.sd}{standard error of A}

\item{B.sd}{standard error of B}

\item{alpha.sd}{standard error of alpha}

\item{beta.sd}{standard error of beta}

\item{covar}{covariances among parameters}

\item{...}{arguments to be passed to methods}
}
\description{
Calculate pharmacokinetic parameters with parameters (A, B, alpha and beta)
in two compartment model "Aexp(-alpha)+Bexp(-beta)"
}
\examples{
TwoComp_Coefficient_Exponent(A=0.196,B=0.0036,alpha=1.221,beta=0.0287,
A.sd=0.002,B.sd=0.00005,alpha.sd=0.09,beta.sd=0.0006)
}
\references{
\url{www.nonmemcourse.com/convert.xls}
}
