#' List of Summary Levels and Official Descriptions
#'
#' This dataset is tibble version of the descriptions of (potentially) available
#' summary levels within the P.L. 94-171 data, as described in the 2018 Redistricting
#' Data Prototype (Public Law 94-171) Summary File documentation.
#'
#' @format a tibble with two columns:
#' \describe{
#' \item{SUMLEV}{The three character summary level code}
#' \item{SUMLEV_description}{The summary level description}
#' }
#'
#' @export
pl_geog_levels = dplyr::tibble(data.frame(
    SUMLEV = c("040","050","060","067",
               "140","150","155","160","170","172","230","280",
               "281","282","283","285","286","288","500",
               "510","511","512","521","531","532","541","550",
               "553","570","571","572","610","612","613","614",
               "615","616","617","618","619","620","622","623",
               "624","625","626","627","628","629","630","631",
               "632","633","634","635","636","637","638","639",
               "640","641","642","643","700","701","702","703",
               "704","705","706","707","708","709","710",
               "715","720","730","735","740","745","750","755",
               "950","960","970"),
    SUMLEV_description = c("State","State-County",
                           "State-County-County Subdivision",
                           "State-County-County Subdivision-Subminor Civil Division",
                           "State-County-Census Tract","State-County-Census Tract-Block Group",
                           "State-Place-County","State-Place",
                           "State-Consolidated City",
                           "State-Consolidated City-Place within Consolidated City","State-Alaska Native Regional Corporation",
                           "State-American Indian Area/Alaska Native Area/Hawaiian Home Land",
                           "State-American Indian Area-Tribal Subdivision/Remainder4",
                           "State-American Indian Area/Alaska Native Area/Hawaiian Home Land-County",
                           "State-American Indian Area/Alaska Native Area (Reservation or Statistical Entity Only)",
                           "State-American Indian Area/Alaska Native Area (Reservation or Statistical Entity Only)-County",
                           "State-American Indian Area (Off-Reservation Trust Land Only)/Hawaiian Home Land",
                           "State-American Indian Area (Off-Reservation Trust Land Only)/Hawaiian Home Land-County","State-Congressional District",
                           "State-Congressional District-County",
                           "State-Congressional District-County-Census Tract",
                           "State-County-Congressional District",
                           "State-Congressional District-County-County Subdivision",
                           "State-Congressional District-Place/Remainder","State-Place-Congressional District",
                           "State-Congressional District-Consolidated City",
                           "State-Congressional District-American Indian Area/Alaska Native Area/HawaiianHome Land",
                           "State-Congressional District-American Indian Area-Tribal Subdivision/Remainder",
                           "State-Congressional District-School District (Elementary)/Remainder",
                           "State-Congressional District-School District (Secondary)/Remainder",
                           "State-Congressional District-School District (Unified)/Remainder",
                           "State-State Legislative District (Upper Chamber)",
                           "State-State Legislative District (Upper Chamber)-County",
                           "State-State Legislative District (Upper Chamber)-County-County Subdivision",
                           "State-State Legislative District (Upper Chamber)-Place/Remainder",
                           "State-State Legislative District (Upper Chamber)-Consolidated City",
                           "State-State Legislative District (Upper Chamber)-American Indian Area/Alaska Native Area/Hawaiian Home Land",
                           "State-State Legislative District (Upper Chamber)-School District (Elementary)/Remainder",
                           "State-State Legislative District (Upper Chamber)-School District (Secondary)/Remainder",
                           "State-State Legislative District (Upper Chamber)-School District (Unified)/Remainder",
                           "State-State Legislative District (Lower Chamber)",
                           "State-State Legislative District (Lower Chamber)-County",
                           "State-State Legislative District (Lower Chamber)-County-County Subdivision",
                           "State-State Legislative District (Lower Chamber)-Place/Remainder",
                           "State-State Legislative District (Lower Chamber)-Consolidated City",
                           "State-State Legislative District (Lower Chamber)-American Indian Area/Alaska Native Area/Hawaiian Home Land",
                           "State-State Legislative District (Lower Chamber)-School District (Elementary)/Remainder",
                           "State-State Legislative District (Lower Chamber)-School District (Secondary)/Remainder",
                           "State-State Legislative District (Lower Chamber)-School District (Unified)/Remainder",
                           "State-State Legislative District (Upper Chamber)-County-Voting District/Remainder",
                           "State-State Legislative District (Upper Chamber)-County-Census Tract",
                           "State-State Legislative District (Upper Chamber)-County-County SubdivisionSubminor Civil Division",
                           "State-State Legislative District (Upper Chamber)-American Indian Area-Tribal Subdivision/Remainder",
                           "State-State Legislative District (Upper Chamber)-Alaska Native Regional Corporation",
                           "State-State Legislative District (Lower Chamber)-County-Voting District/Remainder",
                           "State-State Legislative District (Lower Chamber)-County-Census Tract",
                           "State-State Legislative District (Lower Chamber)-County-County SubdivisionSubminor Civil Division",
                           "State-State Legislative District (Lower Chamber)-American Indian Area-TribalSubdivision/Remainder",
                           "State-State Legislative District (Lower Chamber)-Alaska Native Regional Corporation",
                           "State-County-State Legislative District (Upper Chamber)",
                           "State-County-State Legislative District (Lower Chamber)",
                           "State-Place-State Legislative District (Upper Chamber)",
                           "State-Place-State Legislative District (Lower Chamber)",
                           "State-County-Voting District/Remainder",
                           "State-County-Voting District/Remainder-Place/Remainder",
                           "State-County-Voting District/Remainder-Consolidated City",
                           "State-County-Voting District/Remainder-American Indian Area/Alaska Native Area/Hawaiian Home Land",
                           "State-County-Voting District/Remainder-American Indian Area-Tribal Subdivision/Remainder",
                           "State-County-Voting District/Remainder-Alaska Native Regional Corporation",
                           "State-County-Voting District/Remainder-School District (Elementary)/Remainder",
                           "State-County-Voting District/Remainder-School District (Secondary)/Remainder",
                           "State-County-Voting District/Remainder-School District (Unified)/Remainder",
                           "State-County-Voting District/Remainder-Census Tract",
                           "State-County-Voting District/Remainder-County Subdivision",
                           "State-County-Voting District/Remainder-County Subdivision-Subminor Civil Division",
                           "State-County-Voting District/Remainder-County Subdivision-Place/Remainder",
                           "State-County-Voting District/Remainder-County Subdivision-Place/RemainderCensus Tract",
                           "State-County-Voting District/Remainder-County Subdivision-Subminor Civil Division-Census Tract",
                           "State-County-Voting District/Remainder-County Subdivision-Place/RemainderCensus Tract-Block Group",
                           "State-County-Voting District/Remainder-County Subdivision-Subminor Civil Division-Census Tract-Block Group",
                           "State-County-Voting District/Remainder-County Subdivision-Place/RemainderCensus Tract-Block Group-Block",
                           "State-County-Voting District/Remainder-County Subdivision-Subminor Civil Division-Census Tract-Block Group-Block",
                           "State-School District (Elementary)/Remainder","State-School District (Secondary)/Remainder",
                           "State-School District (Unified)/Remainder")
))

# prepared with `dpasta` package from sum_level.csv file in data-raw/
