% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plfd.R
\name{plfd}
\alias{plfd}
\title{PLFD}
\usage{
plfd(x, y, r0, c0, blockList, blockMode = NULL, permNum = 100, alpha = 0)
}
\arguments{
\item{x}{Array of \mjseqn{r \times c \times n}.}

\item{y}{Vector of length-\mjseqn{n} with values 1 or 2.}

\item{r0, c0}{Row and column size of blocks. See details.}

\item{blockList}{List including the index set of pre-specified blocks. See details.}

\item{blockMode}{How the differential structure of \mjseqn{M_1 - M_2} are
detected. The default (\code{blockMode=NULL}) does NOT detect the structure of feature
blocks. If \code{blockMode="fd"}(or \code{"forward"}), a forward stepwise procedure is
conducted to detect the nonzero positions of feature blocks, wherein BIC serves
as the stopping rule.}

\item{permNum}{Rounds of permutation.}

\item{alpha}{The \strong{upper}-\mjseqn{\alpha} quantile of the permutation statistic.}
}
\value{
List.
\itemize{
\item \code{n1}, \code{n2}, \code{rDim}, \code{cDim}, \code{blockMode}, \code{permNum}, \code{alpha};
\item \code{blockNumber}: the number of identified feature blocks.
\item \code{paras}: \code{list(list(rIdx, cIdx, B, M), ...)}, list of the information of
feature blocks.
}
}
\description{
\loadmathjax
A portmanteau local feature discrimination (PLFD) approach to the classification with
high-dimensional matrix-variate data.
}
\details{
There are two ways to specify the blocks under consideration. In the case that
the matrix-variate is partition into non-overlapping blocks that share the common
row size and column size, these sizes can be specified by \code{r0} and \code{c0}. Otherwise, the
blocks can be flexibly specified by parameter \code{blockList}, which should be a list in
which each element includes \code{rIdx} and \code{cIdx} corresponding to the row and column index
set of a block. See examples.
}
\examples{
set.seed(2023)
rDim <- 20
cDim <- 20

n <- 100
y <- sample(1:2, n, TRUE, c(0.5, 0.5))
x <- array(rnorm(rDim*cDim*n), dim=c(rDim, cDim, n))
x[, , y==2] <- (x[, , y==2] + 1.0)

ntest <- 200
ytest <- sample(1:2, ntest, TRUE, c(0.5, 0.5))
xtest <- array(rnorm(rDim*cDim*ntest), dim=c(rDim, cDim, ntest))
xtest[, , ytest==2] <- (xtest[, , ytest==2] + 1.0)

## Uniform partition
print( plfd(x, y, r0=5, c0=5) )

## Pre-specify feature blocks
blockList <- list(list(rIdx=1:5, cIdx=1:5), 
                  list(rIdx=6:10, cIdx=1:5), 
                  list(rIdx=3:9, cIdx=2:8))
print( plfd.model <- plfd(x, y, blockList=blockList) )

## Predict
predict(plfd.model, xtest, ytest)

}
\references{
Xu Z., Luo S. and Chen Z. (2021). A Portmanteau Local Feature Discrimination
Approach to the Classification with High-dimensional Matrix-variate Data. Sankhya A.
\doi{10.1007/s13171-021-00255-2}
}
