% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{mapPLMIX}
\alias{mapPLMIX}
\title{MAP estimation for a Bayesian mixture of Plackett-Luce models}
\usage{
mapPLMIX(pi_inv, K, G, init = list(p = NULL, omega = NULL), n_iter = 1000,
  hyper = list(shape0 = matrix(1, nrow = G, ncol = K), rate0 = rep(0, G),
  alpha0 = rep(1, G)), eps = 10^(-12), centered_start = FALSE,
  plot_objective = TRUE)
}
\arguments{
\item{pi_inv}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial orderings.}

\item{K}{Number of possible items.}

\item{G}{Number of mixture components.}

\item{init}{List of named objects with initialization values: \code{p} is a numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix of component-specific support parameters; \code{omega} is a numeric vector of \eqn{G} mixture weights. Default is \code{NULL}. In this case initialization values are randomly generated with a uniform distribution. With the optional argument \code{centered_start} one can draw from a different distribution enforcing the expectation of the support parameters to coincide with the relative frequency that each item has been ranked top.}

\item{n_iter}{Maximum number of EM iterations.}

\item{hyper}{List of named objects with hyperparameter values for prior specification: \code{shape0} is a numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix of shape hyperparameters; \code{rate0} is a numeric vector of \eqn{G} rate hyperparameters; \code{alpha0} is a numeric vector of \eqn{G} Dirichlet hyperparameters. Default is noninformative (flat) prior setting.}

\item{eps}{Tolerance value for the convergence criterion.}

\item{centered_start}{Logical: whether a random start whose support parameters and weights are constrained to be centered around the observed relative frequency that each item has been ranked top. Default is \code{FALSE}. Ignored when \code{init} is not \code{NULL}.}

\item{plot_objective}{Logical: whether the objective function should be plotted. Default is \code{FALSE}.}
}
\value{
A list of named objects:

 \item{\code{P_map}}{ Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the MAP estimates of the component-specific support parameters.}
 \item{\code{Rho_map}}{ Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the MAP estimates of the component-specific reference orders.}
 \item{\code{W_map}}{ Numeric vector of the \eqn{G} MAP estimates of the mixture weights.}
 \item{\code{z_hat}}{ Numeric \eqn{N}\eqn{\times}{x}\eqn{G} matrix of estimated posterior component membership probabilities.}
 \item{\code{classification}}{ Numeric vector of \eqn{N} component memberships based on MAP allocation.}
 \item{\code{log_lik}}{ Numeric vector of log-likelihood values at each iteration.}
 \item{\code{objective}}{ Numeric vector of objective function values at each iteration.}
 \item{\code{max_objective}}{ Maximized objective function value.}
 \item{\code{bic}}{ BIC value.}
 \item{\code{conv}}{ Binary convergence indicator: 1 = convergence has been achieved, 0 = otherwise.}
}
\description{
Perform MAP estimation via EM algorithm for a Bayesian mixture of Plackett-Luce models fitted to partial orderings.
}
\details{
Under noninformative (flat) prior setting, the EM algorithm for MAP estimation corresponds to the EMM algorithm described by Gormley and Murphy (2006) to perform frequentist inference. Thus, in this case the MAP solution coincides with the MLE. In this case, also the \code{log_lik} and \code{objective} output vectors coincide.
}
\examples{
library(PLMIX)
data(d_carconf)
K <- ncol(d_carconf)
G <- 3
outputMAP <- mapPLMIX(pi_inv=d_carconf, K=K, G=G, n_iter=400*G)
str(outputMAP)
outputMAP$P_map
outputMAP$W_map

}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.

Mollica, C., Tardella, L. (2014). Epitope profiling via mixture modeling for ranked data. \emph{Statistics in Medicine}, \bold{33}(21), pages 3738--3758, ISSN: 0277-6715, DOI: 10.1002/sim.6224.
}

