% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{paired_comparisons}
\alias{paired_comparisons}
\title{Paired comparison matrix for a partial ordering/ranking dataset}
\usage{
paired_comparisons(data, format = c("ordering", "ranking"), nranked = NULL)
}
\arguments{
\item{data}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial sequences.}

\item{format}{Character string indicating the format of the \code{data} argument.}

\item{nranked}{Optional numeric vector of length \eqn{N} with the number of items ranked by each sample unit.}
}
\value{
Numeric \eqn{K}\eqn{\times}{x}\eqn{K} paired comparison matrix: the \eqn{(i,i')}-th entry indicates the number of sample units that preferred item \eqn{i} to item \eqn{i'}.
}
\description{
Construct the paired comparison matrix for a partial ordering/ranking dataset.
}
\examples{
library(PLMIX)
data(d_dublinwest)
paired_comparisons(data=d_dublinwest, format="ordering")
}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.
}

