% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{fisher}
\alias{fisher}
\alias{fisher.PLNfit}
\title{Fisher information matrix for Theta}
\usage{
fisher(object, type)

\method{fisher}{PLNfit}(object, type = c("wald", "louis"))
}
\arguments{
\item{object}{an R6 object with class PLNfit}

\item{type}{Either \code{wald} (default) or \code{louis}. Approximation scheme used to compute the Fisher information matrix}
}
\value{
A block-diagonal matrix with p (number of species) blocks of size d (number of covariates), assuming
\eqn{\Theta} is a matrix of size d * p.
}
\description{
Extracts Fisher information matrix of \eqn{\Theta} from objects returned by \code{\link[=PLN]{PLN}} and its variants. Fisher matrix is computed using one of two approximation scheme: wald (default, conservative, gives large confidence interval) or louis (anticonservative). Note that the Fisher information matrix is the full-data version (scaled by the number of observations), usually noted \deqn{I_n(\theta)}.
}
\section{Methods (by class)}{
\itemize{
\item \code{fisher(PLNfit)}: Fisher information matrix for PLNfit

}}
\seealso{
\code{\link[=standard_error.PLNfit]{standard_error}} for standard errors
}
