% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfit-S3methods.R
\name{plot.PLNPCAfit}
\alias{plot.PLNPCAfit}
\title{PCA vizualiation (individual and/or variable factor map(s)) for a \code{PLNPCAfit} object}
\usage{
\method{plot}{PLNPCAfit}(
  x,
  map = c("both", "individual", "variable"),
  nb_axes = min(3, x$rank),
  axes = seq.int(min(2, x$rank)),
  ind_cols = "ind_colors",
  var_cols = "var_colors",
  plot = TRUE,
  main = NULL,
  ...
)
}
\arguments{
\item{x}{an R6 object with class PLNPCAfit}

\item{map}{the type of output for the PCA vizualization: either "individual", "variable" or "both". Default is "both".}

\item{nb_axes}{scalar: the number of axes to be considered when map = "both". The default is min(3,rank).}

\item{axes}{numeric, the axes to use for the plot when map = "individual" or "variable". Default it c(1,min(rank))}

\item{ind_cols}{a character, factor or numeric to define the color associated with the individuals. By default, all variables receive the default color of the current palette.}

\item{var_cols}{a character, factor or numeric to define the color associated with the variables. By default, all variables receive the default color of the current palette.}

\item{plot}{logical. Should the plot be displayed or sent back as ggplot object}

\item{main}{character. A title for the single plot (individual or variable factor map). If NULL (the default), an hopefully appropriate title will be used.}

\item{...}{Not used (S3 compatibility).}
}
\value{
displays an individual and/or variable factor maps for the corresponding axes, and/or sends back a ggplot2 or gtable object
}
\description{
PCA vizualiation (individual and/or variable factor map(s)) for a \code{PLNPCAfit} object
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCAs <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)
myPCA <- getBestModel(myPCAs)
\dontrun{
plot(myPCA, map = "individual", nb_axes=2, ind_cols = trichoptera$Group)
plot(myPCA, map = "variable", nb_axes=2)
plot(myPCA, map = "both", nb_axes=2, ind_cols = trichoptera$Group)
}
}
