% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-S3methods.R
\name{standard_error}
\alias{standard_error}
\alias{standard_error.PLNfit}
\title{Component-wise standard errors of Theta}
\usage{
standard_error(object, type)

\method{standard_error}{PLNfit}(object, type = c("wald", "louis"))
}
\arguments{
\item{object}{an R6 object with class PLNfit}

\item{type}{Either `Wald` (default) or `Louis`. Approximation scheme used to compute the Fisher information matrix}
}
\value{
A p * d positive matrix (same size as \eqn{\Theta}) with standard errors for the coefficients of \eqn{\Theta}
}
\description{
Extracts univariate standard errors for the estimated coefficient of Theta. Standard errors are computed from the (approximate) Fisher information matrix. See \code{\link[=fisher.PLNfit]{fisher}} for more details on the approximations.
}
\section{Methods (by class)}{
\itemize{
\item \code{PLNfit}: Component-wise standard errors of Theta in PLNfit
}}

\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1 + offset(log(Offset)), data = trichoptera)
standard_error(myPLN, "wald")
}
\seealso{
\code{\link[=vcov.PLNfit]{vcov}} for the complete Fisher information matrix
}
