% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCA.R
\name{PLNPCA}
\alias{PLNPCA}
\title{Poisson lognormal model towards Principal Component Analysis}
\usage{
PLNPCA(formula, data, subset, weights, ranks = 1:5, control = PLNPCA_param())
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which lm is called.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{weights}{an optional vector of observation weights to be used in the fitting process.}

\item{ranks}{a vector of integer containing the successive ranks (or number of axes to be considered)}

\item{control}{a list-like structure for controlling the optimization, with default generated by \code{\link[=PLNPCA_param]{PLNPCA_param()}}.  See the associated documentation.
for details.}
}
\value{
an R6 object with class \code{\link{PLNPCAfamily}}, which contains
a collection of models with class \code{\link{PLNPCAfit}}
}
\description{
Fit the PCA variants of the Poisson lognormal with a variational algorithm. Use the (g)lm syntax for model specification (covariates, offsets).
}
\examples{
#' ## Use future to dispatch the computations on 2 workers
\dontrun{
future::plan("multisession", workers = 2)
}

data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCA <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)

# Shut down parallel workers
\dontrun{
future::plan("sequential")
}
}
\seealso{
The classes \code{\link{PLNPCAfamily}} and \code{\link{PLNPCAfit}}, and the configuration function \code{\link[=PLNPCA_param]{PLNPCA_param()}}.
}
