% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIPLNfit-class.R
\name{ZIPLNfit}
\alias{ZIPLNfit}
\title{An R6 Class to represent a ZIPLNfit}
\description{
The function \code{\link[=ZIPLN]{ZIPLN()}} fits a model which is an instance of an object with class \code{\link{ZIPLNfit}}.

This class comes with a set of R6 methods, some of which are useful for the end-user and exported as S3 methods.
See the documentation for \code{\link[=coef]{coef()}}, \code{\link[=sigma]{sigma()}}, \code{\link[=predict]{predict()}}.

Fields are accessed via active binding and cannot be changed by the user.
}
\details{
Covariates for the Zero-Inflation parameter (using a logistic regression model) can be specified in the formula RHS using the pipe
(\verb{~ PLN effect | ZI effect}) to separate covariates for the PLN part of the model from those for the Zero-Inflation part.
Note that different covariates can be used for each part.
}
\examples{
\dontrun{
# See other examples in function ZIPLN
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- ZIPLN(Abundance ~ 1, data = trichoptera)
class(myPLN)
print(myPLN)
}

}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{n}}{number of samples/sites}

\item{\code{q}}{number of dimensions of the latent space}

\item{\code{p}}{number of variables/species}

\item{\code{d}}{number of covariates in the PLN part}

\item{\code{d0}}{number of covariates in the ZI part}

\item{\code{nb_param_zi}}{number of parameters in the ZI part of the model}

\item{\code{nb_param_pln}}{number of parameters in the PLN part of the model}

\item{\code{nb_param}}{number of parameters in the ZIPLN model}

\item{\code{model_par}}{a list with the matrices of parameters found in the model (B, Sigma, plus some others depending on the variant)}

\item{\code{var_par}}{a list with two matrices, M and S2, which are the estimated parameters in the variational approximation}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{latent}}{a matrix: values of the latent vector (Z in the model)}

\item{\code{latent_pos}}{a matrix: values of the latent position vector (Z) without covariates effects or offset}

\item{\code{fitted}}{a matrix: fitted values of the observations (A in the model)}

\item{\code{vcov_model}}{character: the model used for the covariance (either "spherical", "diagonal", "full" or "sparse")}

\item{\code{zi_model}}{character: the model used for the zero inflation (either "single", "row", "col" or "covar")}

\item{\code{loglik}}{(weighted) variational lower bound of the loglikelihood}

\item{\code{loglik_vec}}{element-wise variational lower bound of the loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{entropy}}{Entropy of the variational distribution}

\item{\code{entropy_ZI}}{Entropy of the variational distribution}

\item{\code{entropy_PLN}}{Entropy of the Gaussian variational distribution in the PLN component}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{criteria}}{a vector with loglik, BIC, ICL and number of parameters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ZIPLNfit-update}{\code{ZIPLNfit$update()}}
\item \href{#method-ZIPLNfit-new}{\code{ZIPLNfit$new()}}
\item \href{#method-ZIPLNfit-optimize}{\code{ZIPLNfit$optimize()}}
\item \href{#method-ZIPLNfit-optimize_vestep}{\code{ZIPLNfit$optimize_vestep()}}
\item \href{#method-ZIPLNfit-predict}{\code{ZIPLNfit$predict()}}
\item \href{#method-ZIPLNfit-show}{\code{ZIPLNfit$show()}}
\item \href{#method-ZIPLNfit-print}{\code{ZIPLNfit$print()}}
\item \href{#method-ZIPLNfit-clone}{\code{ZIPLNfit$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-update"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-update}{}}}
\subsection{Method \code{update()}}{
Update a \code{\link{ZIPLNfit}} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$update(
  B = NA,
  B0 = NA,
  Pi = NA,
  Omega = NA,
  Sigma = NA,
  M = NA,
  S = NA,
  R = NA,
  Ji = NA,
  Z = NA,
  A = NA,
  monitoring = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{B}}{matrix of regression parameters in the Poisson lognormal component}

\item{\code{B0}}{matrix of regression parameters in the zero inflated component}

\item{\code{Pi}}{Zero inflated probability parameter (either scalar, row-vector, col-vector or matrix)}

\item{\code{Omega}}{precision matrix of the latent variables}

\item{\code{Sigma}}{covariance matrix of the latent variables}

\item{\code{M}}{matrix of mean vectors for the variational approximation}

\item{\code{S}}{matrix of standard deviation parameters for the variational approximation}

\item{\code{R}}{matrix of probabilities for the variational approximation}

\item{\code{Ji}}{vector of variational lower bounds of the log-likelihoods (one value per sample)}

\item{\code{Z}}{matrix of latent vectors (includes covariates and offset effects)}

\item{\code{A}}{matrix of fitted values}

\item{\code{monitoring}}{a list with optimization monitoring quantities}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Update the current \code{\link{ZIPLNfit}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-new"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{\link{ZIPLNfit}} model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$new(data, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a named list used internally to carry the data matrices}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-optimize}{}}}
\subsection{Method \code{optimize()}}{
Call to the Cpp optimizer and update of the relevant fields
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$optimize(data, control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a named list used internally to carry the data matrices}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-optimize_vestep"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-optimize_vestep}{}}}
\subsection{Method \code{optimize_vestep()}}{
Result of one call to the VE step of the optimization procedure: optimal variational parameters (M, S, R) and corresponding log likelihood values for fixed model parameters (Sigma, B, B0). Intended to position new data in the latent space.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$optimize_vestep(
  data,
  B = self$model_par$B,
  B0 = self$model_par$B0,
  Omega = self$model_par$Omega,
  control = ZIPLN_param(backend = "nlopt")$config_optim
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{a named list used internally to carry the data matrices}

\item{\code{B}}{Optional fixed value of the regression parameters in the PLN component}

\item{\code{B0}}{Optional fixed value of the regression parameters in the ZI component}

\item{\code{Omega}}{inverse variance-covariance matrix of the latent variables}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with three components:
\itemize{
\item the matrix \code{M} of variational means,
\item the matrix \code{S} of variational standard deviations
\item the matrix \code{R} of variational ZI probabilities
\item the vector \code{Ji} of (variational) log-likelihood of each new observation
\item a list \code{monitoring} with information about convergence status
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-predict"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-predict}{}}}
\subsection{Method \code{predict()}}{
Predict position, scores or observations of new data. See \code{\link[=predict.ZIPLNfit]{predict.ZIPLNfit()}} for the S3 method and additional details
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$predict(
  newdata,
  responses = NULL,
  type = c("link", "response", "deflated"),
  level = 1,
  envir = parent.frame()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{A data frame in which to look for variables with which to predict. If omitted, the fitted values are used.}

\item{\code{responses}}{Optional data frame containing the count of the observed variables (matching the names of the provided as data in the PLN function), assuming the interest in in testing the model.}

\item{\code{type}}{Scale used for the prediction. Either \code{"link"} (default, predicted positions in the latent space), \code{"response"} (predicted average counts, accounting for zero-inflation) or \code{"deflated"} (predicted average counts, not accounting for zero-inflation and using only the PLN part of the model).}

\item{\code{level}}{Optional integer value the level to be used in obtaining the predictions. Level zero corresponds to the population predictions (default if \code{responses} is not provided) while level one (default) corresponds to predictions after evaluating the variational parameters for the new data.}

\item{\code{envir}}{Environment in which the prediction is evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix with predictions scores or counts.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-show"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-show}{}}}
\subsection{Method \code{show()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$show(
  model = paste("A multivariate Zero Inflated Poisson Lognormal fit with",
    self$vcov_model, "covariance model.\\n")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{First line of the print output}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-print"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-print}{}}}
\subsection{Method \code{print()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ZIPLNfit-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ZIPLNfit-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ZIPLNfit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
