% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manyOneUTest.R
\name{manyOneUTest}
\alias{manyOneUTest}
\alias{manyOneUTest.default}
\alias{manyOneUTest.formula}
\title{Multiple Comparisons with One Control (U-test)}
\usage{
manyOneUTest(x, ...)

\method{manyOneUTest}{default}(x, g, alternative = c("two.sided", "greater",
  "less"), p.adjust.method = c("single-step", p.adjust.methods), ...)

\method{manyOneUTest}{formula}(formula, data, subset, na.action,
  alternative = c("two.sided", "greater", "less"),
  p.adjust.method = c("single-step", p.adjust.methods), ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}})}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs pairwise comparisons of multiple group levels with
one control.
}
\details{
This functions performs Wilcoxon, Mann and Whitney's U-test
for a one factorial design where each factor level is tested against
one control (\eqn{m = k -1} tests). As the data are re-ranked
for each comparison, this test is only suitable for
balanced (or almost balanced) experimental designs.

For the two-tailed test and \code{p.adjust.method = "single-step"}
the multivariate normal distribution is used for controlling
Type 1 error and to calculate p-values. Otherwise,
the p-values are calculated from the standard normal distribution
with any latter p-adjustment as available by \code{\link{p.adjust}}.
}
\references{
OECD (ed. 2006), \emph{Current approaches in the statistical analysis
of ecotoxicity data: A guidance to application}. OECD Series
on testing and assessment, No. 54.
}
\seealso{
\code{\link{wilcox.test}}, \code{\link{pmvnorm}}, \code{\link{Normal}}
}
\concept{
ManyOne
}
\keyword{htest}
\keyword{nonparanetric}
