% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chaAllPairsNashimotoTest.R
\name{chaAllPairsNashimotoTest}
\alias{chaAllPairsNashimotoTest}
\alias{chaAllPairsNashimotoTest.default}
\alias{chaAllPairsNashimotoTest.formula}
\title{All-Pairs Comparisons for Simply Ordered Mean Ranksums}
\usage{
chaAllPairsNashimotoTest(x, ...)

\method{chaAllPairsNashimotoTest}{default}(
  x,
  g,
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)

\method{chaAllPairsNashimotoTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  p.adjust.method = c("single-step", p.adjust.methods),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{p.adjust.method}{method for adjusting p values}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a 
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
 \item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Nashimoto and Wright's all-pairs comparison procedure
for simply ordered mean ranksums (NPY' test and NPT' test).
According to the authors, bove procedures shall only be
applied after Chacko's test (see \code{\link{chackoTest}}) indicates
global significance.

The modified procedure uses the property of a simple order,
\eqn{\theta_m' - \theta_m \le \theta_j - \theta_i \le \theta_l' - \theta_l
\qquad (l \le i \le m~\mathrm{and}~ m' \le j \le l')}.
The null hypothesis H\eqn{_{ij}: \theta_i = \theta_j} is tested against
the alternative A\eqn{_{ij}: \theta_i < \theta_j} for any
\eqn{1 \le i < j \le k}.

In the NPY' test the p-values are estimated from the
studentized range distribution. In the NPT' test the p-values
are estimated from the standard normal distribution.
}
\details{
The type of test can be controlled via the argument \code{p.adjust.method}:
\describe{
\item{single.step}{the NPY' test is performed.}
\item{none}{the plain NPT' test is performed.}
}
However, any method as available by \code{\link{p.adjust.methods}} can
be selected for the adjustment of p-values estimated from
the standard normal distribution.
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")
chackoTest(x , g)
chaAllPairsNashimotoTest(x, g, p.adjust.method = "single-step")
}
\references{
Nashimoto, K., Wright, F.T., (2005) Multiple comparison procedures
for detecting differences in simply ordered means.
\emph{Comput. Statist. Data Anal.} \bold{48}, 291--306.
}
\seealso{
\code{\link{Tukey}}, \code{\link{Normal}}, \code{\link{chackoTest}}
}
\concept{AllPairsComparisons}
\concept{OrderedAlternatives}
\keyword{htest}
\keyword{nonparametric}
