% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pow.R
\name{pow}
\alias{pow}
\title{Power calculation}
\usage{
pow(
  p_values,
  alpha_locals = NULL,
  alpha_global = 0.05,
  adjust = TRUE,
  adj_init = NULL,
  staircase_steps = NULL,
  alpha_precision = 5,
  fut_locals = NULL,
  multi_logic_a = "all",
  multi_logic_fut = "all",
  multi_logic_global = "any",
  group_by = NULL,
  alpha_loc_nonstop = NULL,
  round_to = 5,
  iter_limit = 100,
  seed = 8,
  prog_bar = FALSE,
  hush = FALSE
)
}
\arguments{
\item{p_values}{A \code{\link{data.frame}} containing the simulated
iterations, looks, and corresponding H0 and H1 p value outcomes, as returned
by the \code{\link[POSSA:sim]{POSSA::sim}} function. (Custom data frames are
also accepted, but may not work as expected.)}

\item{alpha_locals}{A number, a numeric vector, or a named \code{\link{list}}
of numeric vectors, that specify the initial set of local alphas that decide
on statistical significance (for interim looks as well as for the final
look), and, if significant, stop the experiment at the given interim look;
to be adjusted via the \code{adjust} function; see the \code{adjust}
parameter below. Any of the numbers included can always be \code{NA} values
as well (which indicates alphas to be calculated; again, see the related
\code{adjust} parameter below). In case of a vector or a list of vectors,
the length of each vector must correspond exactly to the maximum number of
looks in the \code{p_values} data frame. When a \code{\link{list}} is given,
the names of the list element(s) must correspond to the root of the related
H0 and H1 p value column name pair(s) (in the \code{p_values} data frame),
that is, without the "\code{_h0}" and "\code{_h1}" suffixes: for example, if
the column name pair is "\code{p_test4_h0}" and "\code{p_test4_h1}", the
name of the corresponding list element should be "\code{p_test4}". If a
single number or a single numeric vector is given, all potential p value
column pairs are automatically detected as starting with "\code{p_}" prefix
and ending with "\code{_h0}" and "\code{_h1}". In case of a single vector
given, each such automatically detected p value pair receives this same
vector. In case of a single number given, all elements of all vectors will
be assigned this same number (up to the maximum number of looks). If a list
is given and any of the elements contain just one number, it will be
extended into a vector (up to the maximum number of looks). The default
\code{NULL} value specifies "fixed design" (no interim stopping alphas) with
final alpha as specified as \code{alpha_global}, without adjustment
procedure as long as the \code{adjust} argument is also left as default
\code{TRUE}. (This is useful for cases where only futility bounds are to be
set for stopping.)}

\item{alpha_global}{Global alpha (expected type 1 error rate in total);
\code{0.05} by default. See also \code{multi_logic_global} for when multiple
p values are being evaluated.}

\item{adjust}{The function via which the initial vector local alphas is
modified with each step of the staircase procedure. Three arguments are
passed to it: \code{adj}, \code{orig}, and \code{prev}. The \code{adj}
parameter is mandatory; it passes the pivotal changing value that, starting
from an initial value (see \code{adj_init}), should, via the staircase
steps, decrease when the global type 1 error rate is too large, and increase
when the global type 1 error rate is too small. The \code{orig} parameter
(optional) always passes the same original vector of alphas as they were
provided via \code{alpha_locals}. The \code{prev} parameter (optional)
passes the "latest" vector of local alphas, which were obtained in the
previous adjustment step (or, in the initial run, it is the original vector,
i.e., the same as \code{orig}). When \code{TRUE} (default), if the given
\code{alpha_locals} contains any \code{NA}s, an \code{adjust} function is
given internally that simply replaces \code{NA}s with the varying adjustment
value (as \code{{ prev[is.na(orig)] = adj; return(prev) }}). If
\code{alpha_locals} contains no \code{NA}s, an \code{adjust} function is
given that multiplies each original local alpha with the varying adjustment
value (as \code{{ return(orig * adj) }}). When set to \code{FALSE}, there
will be no adjustment (staircase procedure omitted): this is useful to
calculate the global type 1 error rate for any given set of local alphas.
Furthermore, if both \code{adjust} and \code{alpha_locals} are left as
default (\code{TRUE} and \code{NULL}), the staircase procedure will be
omitted.}

\item{adj_init}{The initial adjustment value that is used as the "\code{adj}"
parameter in the "\code{adjust}" function and is continually adjusted via
the staircase steps (see \code{staircase_steps} parameter). When \code{NULL}
(default), assuming that "\code{adj}" is used as a replacement for
\code{NA}s, \code{adj_init} is calculated as the global alpha divided by the
maximum number of looks (Bonferroni correction), as a rough initial
approximation. However, multiplication is assumed when finding any
multiplication sign (\code{*}) in a given custom \code{adjust} function: in
such a case, \code{adj_init} will be \code{1} by default.}

\item{staircase_steps}{Numeric vector that specifies the (normally decreasing)
sequence of step sizes for the staircase that narrows down on the specified
global error error by decreasing or increasing the adjustment value
(initially: \code{adj_init}): the step size (numeric value) is added for
increase, and subtracted for decrease. Whenever the direction (decrease vs.
increase) is changed, the staircase moves on to the next step size. When the
direction changes and there are no more steps remaining, the procedure is
finished (regardless of the global error rate). By default (\code{NULL}),
the \code{staircase_steps} is either "\code{0.01 * (0.5 ^ (seq(0, 11, 1)))}"
(giving: \code{0.01, 0.005, 0.0025, ...}) or "\code{0.5 * (0.5 ^ (seq(0, 11,
1)))}" (giving: \code{0.05, 0.025, 0.0125, ...}). The latter is chosen when
adjustment via multiplication is assumed, which is simply based on finding
any multiplication sign (\code{*}) in a given custom \code{adjust} function.
The former is chosen in any other case.}

\item{alpha_precision}{During the staircase procedure, at any point when the
simulated global type 1 error rate first matches the given
\code{alpha_global} at least for the number of fractional digits given here
(\code{alpha_precision}; default: \code{5}), the procedure stops and the
results are printed. (Otherwise, the procedures finishes only when all steps
given as \code{staircase_steps} have been used.)}

\item{fut_locals}{Specifies local futility bounds that may stop the experiment
at the given interim looks if the corresponding p value is above the given
futility bound value. When \code{NULL} (default), sets no futility bounds.
Otherwise, it follows the same logic as \code{alpha_locals} and has the same
input possibilities (number, numeric vector, or named list of numeric
vectors).}

\item{multi_logic_a}{When multiple p values are evaluated for local alpha
stopping rules, \code{multi_logic_a} specifies the function used for how to
evaluate the multiple significance outcomes (p values being below or above
the given local alphas) as a single \code{TRUE} or \code{FALSE} value that
decides whether or not to stop at a given look. The default, \code{'all'},
specifies that all of the p values must be below the local boundary for
stopping. The other acceptable character input is \code{'any'}, which
specifies that the collection stops when any of the p values pass the
boundary for stopping. Instead of these strings, the actual
\code{\link{all}} and \code{\link{any}} would lead to identical outcomes,
respectively, but the processing would be far slower (since the string
\code{'all'} or \code{'any'} inputs specify a dedicated faster internal
solution). For custom combinations, any custom function can be given, which
will take, as arguments, the p value columns in their given order (either in
the \code{p_values} data frame, or as specified in \code{alpha_locals}), and
should return a single \code{TRUE} or \code{FALSE} value.}

\item{multi_logic_fut}{Same as \code{multi_logic_a} (again with \code{'all'}
as default), but for futility bounds (for the columns specified in
\code{fut_locals}).}

\item{multi_logic_global}{Similar as \code{multi_logic_a}, but for the
calculation of the global type 1 error rate (again: in case of multiple p
values being evaluated; otherwise this parameter is not relevant), and with
\code{'any'} by default. This default means that if any of the p values
under evaluation (specified via \code{alpha_locals} or detected
automatically) is significant (p value below the given local alpha at the
stopping of the simulated "experiment" iteration) in case of the H0
scenario, this is calculated as a type 1 error. If \code{'all'} were
specified, only cases with all p evaluated values being significant are
counted as type 1 errors. In either case, the ratio of outcomes with such
type 1 errors (out of all iterations) gives the global type 1 error rate,
which is intended to (approximately) match (via the adjustment procedure)
the value specified as \code{alpha_global}. This global type 1 error is also
what is printed to the console in the end as the "combined" global error
rate. Furthermore, the logic given here is also used for the calculation of
the "combined" global power printed to the console. In this case, the
\code{'any'} logic, for example, would mean that, if any of the p values are
significant at the end of the experiment, this is a positive finding. The
global power is then the ratio of iterations with such positive findings.}

\item{group_by}{When given as a character element or vector, specifies the
factors by which to group the analysis: the \code{p_values} data will be
divided into parts by these factors and these parts will be analyzed
separately, with power and error information calculated per each part. By
default (\code{NULL}), it identifies factors, if any, given to the
\code{sim} function (via \code{fun_obs}) that created the given
\code{p_values} data.}

\item{alpha_loc_nonstop}{Optional "non-stopper" alphas via which to evaluate p
values per look, but without stopping the data collection regardless of
statistical significance. Must be a list with names indicating p value
column name pairs, similarly as for the \code{alpha_locals} argument; see
\code{alpha_locals} for details.}

\item{round_to}{Number of fractional digits (default: \code{5}) to round to,
for the displayed numeric information (such as alphas and power; mainly for
default value for \code{\link[POSSA:print.possa_pow_list]{printing}}).}

\item{iter_limit}{In some specific cases of unideal/wrong input, the staircase
may get stuck at a given step's loop process. The \code{iter_limit}
parameter specifies the number (by default \code{100}) at which the script
pauses the loop and offers to the user that the procedure be ceased. If the
user chooses to continue, the offer will always be posed again after the
same number of iterations (e.g., by default, after \code{100}, at
\code{200}, then \code{300}, etc.).}

\item{seed}{Number for \code{\link{set.seed}}; \code{8} by default. Set to
\code{NULL} for random seed.}

\item{prog_bar}{Logical, \code{FALSE} by default. If \code{TRUE}, shows
progress bar.}

\item{hush}{Logical. If \code{TRUE}, prevents printing any details (or the
progress bar) to console.}
}
\value{
The returns a \code{\link{list}} (with class \code{"possa_pow_list"})
 that includes all details of the calculated power, T1ER, and sample
 information. This list can be printed legibly (via POSSA's
 \code{\link[POSSA:print.possa_pow_list]{print()}} method).
}
\description{
Calculates power and local alphas based on simulated p values
 (which should be provided as created by the
 \code{\link[POSSA:sim]{POSSA::sim}} function). The calculation for
 sequential testing involves a staircase procedure during which an initially
 provided set of local alphas is continually adjusted until the (approximate)
 specified global type 1 error rate (e.g., global alpha = .05) is reached:
 the value of adjustment is decreasing while global type 1 error rate is
 larger than specified, and increasing while global type 1 error rate is
 smaller than specified; a smaller step is chosen whenever the direction
 (increase vs. decrease) changes; the procedure stops when the global type 1
 error rate is close enough to the specified one (e.g., matches it up to 4
 fractional digits) or when the specified smallest step is passed. The
 adjustment works via a dedicated ("\code{adjust}") function that either
 replaces missing (\code{NA}) values with varying alternatives or (when there
 are no missing values) in some manner varyingly modifies the initial values
 (e.g. by addition or multiplication).
}
\note{
For the replicability, in case the \code{adjust} function uses any
randomization, \code{\link{set.seed}} is executed in the beginning of this
function, each time it is called; see the \code{seed} parameter.

This function uses, internally, the \code{\link{data.table}} R package.
}
\examples{

# below is a (very) minimal example
# for more, see the vignettes via https://github.com/gasparl/possa#usage

# create sampling function
customSample = function(sampleSize) {
    list(
        sample1 = rnorm(sampleSize, mean = 0, sd = 10),
        sample2_h0 = rnorm(sampleSize, mean = 0, sd = 10),
        sample2_h1 = rnorm(sampleSize, mean = 5, sd = 10)
    )
}

# create testing function
customTest = function(sample1, sample2_h0, sample2_h1) {
 c(
   p_h0 = t.test(sample1, sample2_h0, 'less', var.equal = TRUE)$p.value,
   p_h1 = t.test(sample1, sample2_h1, 'less', var.equal = TRUE)$p.value
 )
}

# run simulation
dfPvals = sim(
    fun_obs = customSample,
    n_obs = 80,
    fun_test = customTest,
    n_iter = 1000
)

# get power info
pow(dfPvals)

}
\seealso{
\code{\link{sim}}
}
