% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postppt.plot.R
\name{postppt.plot}
\alias{postppt.plot}
\title{Plot method for posterior projected Polya tree}
\usage{
postppt.plot(postppt.circ,
plot.type = c("circle", "line", "summary", "a.sim", "mu.sim", "cpos"),
interval = TRUE, control.circular = list(),
shrink = 1, tol = 0.04, ylim = NULL)
}
\arguments{
\item{postppt.circ}{object returned by the \code{dsimpostppt} function.}

\item{plot.type}{type of plot to be drawn:
"circle" for circular plot,
"line" for linear plot,
"summary" for boxplot of mean direction and concentration,
"cpos" for cpos scatter plot
"a.sim" for summary plots of simulated alphas and
"mu.sim" for summary plots of simulated mu1 and mu2.}

\item{interval}{logical. If TRUE 95\% credible intervals will be shown in the circular and linear plots.}

\item{control.circular}{attributes of circular object in order to draw the circle.See \code{\link[circular]{circular}}.}

\item{shrink}{parameter that controls the size of the plotted circle. Default is 1. Larger values shrink the circle, while smaller values enlarge the circle.}

\item{tol}{proportion of white space at the margins of plot.}

\item{ylim}{range to be encompassed by "y" axis.}
}
\description{
Plots posterior projected Polya tree estimates.
}
\examples{
\donttest{ z2 <- dsimpostppt(deer, units = "radians", it = 10, ti =1, bi=0, ha = 1)
postppt.plot(z2, plot.type= "line" , shrink = 1.4, tol = 1.2, ylim = c(0,0.6))
postppt.summary(z2)
postppt.plot(z2, plot.type= "cpos" )
postppt.plot(z2, plot.type= "circle" , shrink = 1.4, tol = 1.2)}

}
\seealso{
\link[base]{plot}, \code{\link[circular]{plot.density.circular}}
}
