% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/PDAopt.R
\name{PDAopt}
\alias{PDAopt}
\title{PP optimization using PDA index}
\usage{
PDAopt(origclass,origdata,q=1,weight=TRUE,lambda=0.1, ...)
}
\arguments{
\item{origclass}{class information vector}

\item{origdata}{data matrix without class information}

\item{q}{dimension of projection matrix}

\item{weight}{weight flag using in PDA index}

\item{lambda}{lambda in PDA index}

\item{...}{arguments to be passed to methods}
}
\value{
indexbest maximum PDA index value

projbest optimal q-dim projection matrix

origclass original class information vector

origdata  original data matrix  without class information
}
\description{
Find the q-dim optimal projection using PDA projectin pursuit index
}
\examples{
data(iris)
PDA.proj.result <- PDAopt(iris[,5],iris[,1:4],weight=TRUE,q=2,lambda=0.1)
PDA.proj.result$indexbest
PDA.proj.result$projbest
}
\references{
Lee, EK., Cook, D.(2010)
A projection pursuit index for large p small n data,
Statistics and Computing, 20:381-392.
}
\keyword{projection}
\keyword{pursuit}

