% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjpval_specific_var.R
\name{adjpval_specific_var}
\alias{adjpval_specific_var}
\title{adjpval_specific_var}
\usage{
adjpval_specific_var(adjptab, varname)
}
\arguments{
\item{adjptab}{A table that includes adjusted p-values for a specific variable.}

\item{varname}{Specify the name of the variable of interest.}
}
\value{
A vector of adjusted p-values for a single variable from the model.
}
\description{
A function to retrieve a vector of adjusted p-values after running PRANA.
}
\examples{
data(combinedCOPDdat_RGO) # A complete data containing expression and clinical data.

# A gene expression data part of the downloaded data.
rnaseqdat = combinedCOPDdat_RGO[ , 8:ncol(combinedCOPDdat_RGO)]
rnaseqdat = as.data.frame(apply(rnaseqdat, 2, as.numeric))

# A clinical data with additional covariates sorted by current smoking groups:
# The first column is ID, so do not include.
phenodat = combinedCOPDdat_RGO[order(combinedCOPDdat_RGO$currentsmoking), 2:7]

# Indices of non-current smoker (namely Group A)
index_grpA = which(combinedCOPDdat_RGO$currentsmoking == 0)
# Indices of current smoker (namely Group B)
index_grpB = which(combinedCOPDdat_RGO$currentsmoking == 1)

# Use PRANA() function to perform the pseudo-value regression analysis.
PRANAres <- PRANA(RNASeqdat = rnaseqdat, clindat = phenodat,
groupA = index_grpA, groupB = index_grpB)

# Create an object to keep the table with adjusted p-values using adjpval() function.
adjpvaltab <- adjpval(PRANAres)

# Retrieve a vector of adjusted p-values for a single variable of interest.
adjpval_specific_var(adjptab = adjpvaltab, varname = "currentsmoking")
}
