% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_functions.R
\name{getTheta}
\alias{getTheta}
\title{Obtain EAP estimates}
\usage{
getTheta(
  data,
  ipar,
  scale = "combined",
  model = "grm",
  theta_grid = seq(-4, 4, 0.1),
  prior_dist = "normal",
  prior_mean = 0,
  prior_sd = 1
)
}
\arguments{
\item{data}{a \code{\linkS4class{PROsetta_data}} object.}

\item{ipar}{a \code{\link{data.frame}} containing item parameters.}

\item{scale}{the index of the scale to use. Set to 'combined' to use the combined scale.}

\item{model}{the item model to use. Accepts 'grm' or 'gpcm'.}

\item{theta_grid}{the theta grid to use in calculating EAP estimates.}

\item{prior_dist}{the type of prior distribution. Accepts '\code{normal}' or '\code{logistic}'.}

\item{prior_mean}{mean of the prior distribution.}

\item{prior_sd}{SD of the prior distribution.}
}
\value{
\code{\link{getTheta}} returns a \code{\link{list}} containing EAP estimates.
}
\description{
\code{\link{getTheta}} is a helper function to calculate EAP estimates.
}
