% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{ptsr.link}
\alias{ptsr.link}
\title{Create a Link for PTSR models}
\usage{
ptsr.link(link = "log")
}
\arguments{
\item{link}{character; one of  \code{"log"}, \code{"log1"}. See \sQuote{Details}.}
}
\value{
An object of class \code{"link-ptsr"}, a list with components

\item{linkfun}{Link function \code{function(mu)}}
\item{linkinv}{Inverse link function \code{function(eta)}}
\item{linkdif}{Derivative \code{function(mu)} \eqn{d\eta / d\mu}{deta/dmu}}
\item{mu.eta}{Derivative \code{function(eta)} \eqn{d\mu / d\eta}{dmu/deta}}
\item{name}{a name to be used for the link}
}
\description{
Given the name of a link, this function returns a link function,
an inverse link function, the derivative   \eqn{d\eta / d\mu}{deta/dmu}
and the derivative \eqn{d\mu / d\eta}{dmu/deta}.
}
\details{
The available links are:

log:    \eqn{f(x) = log(x)}

log1: \eqn{f(x) = log(x-1)}
}
